/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft;

import com.mafuyu33.mafishcrossbow.rougecraft.integration.MafishCrossbowEnchantSelector;
import com.mafuyu33.mafishcrossbow.rougecraft.integration.RoguecraftIntegration;
import com.mafuyu33.mafishcrossbow.rougecraft.integration.RoguecraftLootGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="mafishcrossbow")
public class RoguecraftEventHandler {
    private static final Map<UUID, Boolean> lastRunState = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MafishCrossbowEnchantSelector.onMobKilled(player);
        RoguecraftLootGenerator.onMobKilled((Entity)event.getEntity(), player);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        UUID uuid = player.getUUID();
        boolean currentInRun = RoguecraftIntegration.isInRun(player);
        Boolean lastInRun = lastRunState.get(uuid);
        if (lastInRun == null) {
            lastRunState.put(uuid, currentInRun);
        } else if (!lastInRun.booleanValue() && currentInRun) {
            MafishCrossbowEnchantSelector.onRunStart(player);
            lastRunState.put(uuid, true);
        } else if (lastInRun.booleanValue() && !currentInRun) {
            MafishCrossbowEnchantSelector.onRunEnd(player);
            lastRunState.put(uuid, false);
        }
    }
}

