/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.gui;

import com.mafuyu33.mafishcrossbow.rougecraft.network.EnchantmentChoiceC2SPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.network.EnchantmentOptionsS2CPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.network.SkipEnchantmentC2SPacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EnchantmentSelectionScreen
extends Screen {
    private final String reason;
    private final List<EnchantmentOptionsS2CPacket.EnchantOption> options;
    private static final int PANEL_WIDTH = 300;
    private static final int PANEL_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 250;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BUTTON_SPACING = 10;
    private static final int SKIP_BUTTON_WIDTH = 150;
    private static final int SKIP_BUTTON_HEIGHT = 25;

    public EnchantmentSelectionScreen(String reason, List<EnchantmentOptionsS2CPacket.EnchantOption> options) {
        super((Component)Component.literal((String)"\u9009\u62e9\u9644\u9b54"));
        this.reason = reason;
        this.options = options;
    }

    protected void init() {
        super.init();
        int panelX = (this.width - 300) / 2;
        int panelY = (this.height - 200) / 2;
        int startY = panelY + 50;
        for (int i = 0; i < this.options.size(); ++i) {
            MutableComponent enchantName;
            EnchantmentOptionsS2CPacket.EnchantOption option = this.options.get(i);
            int choiceNum = i + 1;
            int buttonX = (this.width - 250) / 2;
            int buttonY = startY + i * 40;
            if (option.displayName().contains("\u00a77+ ")) {
                String[] parts = option.displayName().split(" \u00a77\\+ ");
                MutableComponent mainEnchant = Component.translatable((String)parts[0]);
                MutableComponent curseMarker = Component.literal((String)" \u00a77+ ").append((Component)Component.translatable((String)parts[1]));
                enchantName = Component.literal((String)("\u00a7d\u00a7l" + choiceNum + ". \u00a7r")).append((Component)mainEnchant).append((Component)curseMarker);
            } else {
                enchantName = Component.literal((String)("\u00a7d\u00a7l" + choiceNum + ". \u00a7r")).append((Component)Component.translatable((String)option.displayName()));
            }
            Button button = Button.builder((Component)enchantName, btn -> this.selectEnchantment(choiceNum)).bounds(buttonX, buttonY, 250, 30).build();
            this.addRenderableWidget((GuiEventListener)button);
        }
        int skipButtonY = startY + this.options.size() * 40 - 5;
        Button skipButton = Button.builder((Component)Component.translatable((String)"gui.mafishcrossbow.rougecraft.skip_button"), btn -> this.skipSelection()).bounds((this.width - 150) / 2, skipButtonY, 150, 25).build();
        this.addRenderableWidget((GuiEventListener)skipButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        int panelX = (this.width - 300) / 2;
        int panelY = (this.height - 200) / 2;
        graphics.fill(panelX, panelY, panelX + 300, panelY + 200, -872415232);
        graphics.fill(panelX, panelY, panelX + 300, panelY + 2, -22016);
        graphics.fill(panelX, panelY + 200 - 2, panelX + 300, panelY + 200, -22016);
        graphics.fill(panelX, panelY, panelX + 2, panelY + 200, -22016);
        graphics.fill(panelX + 300 - 2, panelY, panelX + 300, panelY + 200, -22016);
        MutableComponent title = Component.literal((String)"\u00a76\u00a7l\u3010\u9a6c\u592b\u9c7c\u7684\u5f29\u3011\u53ef\u5347\u7ea7\uff01");
        graphics.drawCenteredString(this.font, (Component)title, this.width / 2, panelY + 15, 0xFFFFFF);
        MutableComponent reasonText = Component.literal((String)("\u00a77(" + this.reason + ")"));
        graphics.drawCenteredString(this.font, (Component)reasonText, this.width / 2, panelY + 30, 0xAAAAAA);
        super.render(graphics, mouseX, mouseY, partialTicks);
        MutableComponent hint = Component.literal((String)"\u00a77\u6309 ESC \u53d6\u6d88");
        graphics.drawCenteredString(this.font, (Component)hint, this.width / 2, panelY + 200 + 10, 0x888888);
    }

    private void selectEnchantment(int choice) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EnchantmentChoiceC2SPacket(choice), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void skipSelection() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SkipEnchantmentC2SPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    public boolean isPauseScreen() {
        return true;
    }
}

