/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.integration;

import com.mafuyu33.mafishcrossbow.ModAttachments;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.rougecraft.client.ModKeys;
import com.mafuyu33.mafishcrossbow.rougecraft.integration.RoguecraftIntegration;
import com.mafuyu33.mafishcrossbow.rougecraft.network.CurseEventS2CPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.network.EnchantmentOptionsS2CPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class MafishCrossbowEnchantSelector {
    private static final Map<UUID, Integer> playerKills = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> lastLevel = new HashMap<UUID, Integer>();
    private static final double CURSE_EVENT_CHANCE = 0.3;
    private static final List<ResourceKey<Enchantment>> CURSE_ENCHANTS = List.of(ModEnchantments.MISFIRE, ModEnchantments.BORE_BURST, ModEnchantments.BAD_LUCK_OF_SEA, ModEnchantments.INTANGIBLE, ModEnchantments.BOWLEFT, ModEnchantments.BOWRIGHT, ModEnchantments.DECREASE_INITIAL_SPEED, ModEnchantments.DECREASE_LIFETIME, ModEnchantments.DECREASE_DAMAGE, ModEnchantments.LEAKY);
    private static final Map<UUID, List<EnchantOption>> pendingChoices = new HashMap<UUID, List<EnchantOption>>();
    private static final Map<UUID, Boolean> curseMode = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> pendingCurseEvent = new HashMap<UUID, Boolean>();

    public static ItemStack createMafishCrossbow() {
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        crossbow.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"\u00a76\u9a6c\u592b\u9c7c\u7684\u5f29").withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        CompoundTag customData = new CompoundTag();
        customData.putBoolean("MafishCrossbow", true);
        crossbow.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
        ArrayList<MutableComponent> loreLines = new ArrayList<MutableComponent>();
        loreLines.add(Component.translatable((String)"tooltip.mafishcrossbow.mafish_crossbow.line1").withStyle(ChatFormatting.GRAY));
        crossbow.set(DataComponents.LORE, (Object)new ItemLore(loreLines, List.of()));
        crossbow.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        crossbow.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        return crossbow;
    }

    public static boolean isMafishCrossbow(ItemStack stack) {
        if (stack.getItem() != Items.CROSSBOW) {
            return false;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        CompoundTag tag = customData.copyTag();
        return tag.getBoolean("MafishCrossbow").orElse(false);
    }

    public static ItemStack findMafishCrossbow(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            CompoundTag tag;
            boolean isMafish;
            CustomData customData;
            if (stack.getItem() != Items.CROSSBOW || (customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) == null || !(isMafish = (tag = customData.copyTag()).getBoolean("MafishCrossbow").orElse(false).booleanValue())) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static void onMobKilled(Player player) {
        if (!RoguecraftIntegration.isInRun(player)) {
            return;
        }
        UUID uuid = player.getUUID();
        int kills = playerKills.getOrDefault(uuid, 0) + 1;
        playerKills.put(uuid, kills);
        if (kills % 10 == 0) {
            int currentPoints = (Integer)player.getData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS);
            player.setData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS, (Object)(currentPoints + 1));
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.gained_point", (Object[])new Object[]{ModKeys.OPEN_ENCHANT_MENU.getTranslatedKeyMessage(), currentPoints + 1}), false);
            player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.5f);
        }
    }

    public static void onKeyPress(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!RoguecraftIntegration.isInRun(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.not_in_run"), false);
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.getItem() != Items.CROSSBOW) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.need_hold_crossbow"), false);
            return;
        }
        int points = (Integer)player.getData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS);
        if (points <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.insufficient_points", (Object[])new Object[]{0}), false);
            return;
        }
        UUID uuid = player.getUUID();
        if (pendingCurseEvent.containsKey(uuid) && pendingCurseEvent.get(uuid).booleanValue()) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CurseEventS2CPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        if (pendingChoices.containsKey(uuid)) {
            MafishCrossbowEnchantSelector.resendCachedOptions(serverPlayer);
            return;
        }
        if (player.getRandom().nextDouble() < 0.3) {
            pendingCurseEvent.put(uuid, true);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CurseEventS2CPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            MafishCrossbowEnchantSelector.offerNormalChoice(serverPlayer);
        }
    }

    private static void resendCachedOptions(ServerPlayer player) {
        UUID uuid = player.getUUID();
        List<EnchantOption> options = pendingChoices.get(uuid);
        boolean isCurseMode = curseMode.getOrDefault(uuid, false);
        if (options == null) {
            return;
        }
        ArrayList<EnchantmentOptionsS2CPacket.EnchantOption> packetOptions = new ArrayList<EnchantmentOptionsS2CPacket.EnchantOption>();
        for (EnchantOption opt : options) {
            Object displayName = isCurseMode && opt.curseHolder != null ? MafishCrossbowEnchantSelector.getEnchantmentTranslationKey((ResourceKey<Enchantment>)opt.holder.getKey()) + " \u00a77+ " + Component.translatable((String)"gui.mafishcrossbow.rougecraft.hidden_curse").getString() : MafishCrossbowEnchantSelector.getEnchantmentTranslationKey((ResourceKey<Enchantment>)opt.holder.getKey());
            packetOptions.add(new EnchantmentOptionsS2CPacket.EnchantOption(opt.holder.getKey().location(), (String)displayName));
        }
        String title = isCurseMode ? Component.translatable((String)"gui.mafishcrossbow.rougecraft.curse_mode_title").getString() : "";
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EnchantmentOptionsS2CPacket(title, packetOptions), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.playSound(isCurseMode ? SoundEvents.WITHER_AMBIENT : SoundEvents.PLAYER_LEVELUP, 1.0f, isCurseMode ? 0.8f : 1.5f);
    }

    public static void offerNormalChoice(ServerPlayer player) {
        UUID uuid = player.getUUID();
        curseMode.put(uuid, false);
        pendingCurseEvent.remove(uuid);
        List<EnchantOption> options = MafishCrossbowEnchantSelector.rollThreeEnchantments((Player)player, false);
        if (options.isEmpty()) {
            return;
        }
        pendingChoices.put(uuid, options);
        ArrayList<EnchantmentOptionsS2CPacket.EnchantOption> packetOptions = new ArrayList<EnchantmentOptionsS2CPacket.EnchantOption>();
        for (EnchantOption opt : options) {
            String displayName = MafishCrossbowEnchantSelector.getEnchantmentTranslationKey((ResourceKey<Enchantment>)opt.holder.getKey());
            packetOptions.add(new EnchantmentOptionsS2CPacket.EnchantOption(opt.holder.getKey().location(), displayName));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EnchantmentOptionsS2CPacket("", packetOptions), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.5f);
    }

    public static void offerCurseChoice(ServerPlayer player) {
        UUID uuid = player.getUUID();
        curseMode.put(uuid, true);
        pendingCurseEvent.remove(uuid);
        List<EnchantOption> options = MafishCrossbowEnchantSelector.rollThreeEnchantments((Player)player, true);
        if (options.isEmpty()) {
            return;
        }
        pendingChoices.put(uuid, options);
        ArrayList<EnchantmentOptionsS2CPacket.EnchantOption> packetOptions = new ArrayList<EnchantmentOptionsS2CPacket.EnchantOption>();
        for (EnchantOption opt : options) {
            String displayName = MafishCrossbowEnchantSelector.getEnchantmentTranslationKey((ResourceKey<Enchantment>)opt.holder.getKey()) + " \u00a77+ " + Component.translatable((String)"gui.mafishcrossbow.rougecraft.hidden_curse").getString();
            packetOptions.add(new EnchantmentOptionsS2CPacket.EnchantOption(opt.holder.getKey().location(), displayName));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EnchantmentOptionsS2CPacket(Component.translatable((String)"gui.mafishcrossbow.rougecraft.curse_mode_title").getString(), packetOptions), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.playSound(SoundEvents.WITHER_AMBIENT, 1.0f, 0.8f);
    }

    private static String getEnchantmentTranslationKey(ResourceKey<Enchantment> key) {
        ResourceLocation loc = key.location();
        return "enchantment." + loc.getNamespace() + "." + loc.getPath();
    }

    private static List<EnchantOption> rollThreeEnchantments(Player player, boolean curseMode) {
        HolderLookup lookup = player.level().holderLookup(Registries.ENCHANTMENT);
        ArrayList<EnchantOption> pool = new ArrayList<EnchantOption>();
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.TRACKING, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.BOUNCE, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.REDIRECT, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.ACCELERATE, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.INCREASE_INITIAL_SPEED, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.INCREASE_DAMAGE, 2);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.INCREASE_LIFETIME, 1);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, (ResourceKey<Enchantment>)Enchantments.PIERCING, 2);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, (ResourceKey<Enchantment>)Enchantments.MULTISHOT, 3);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, (ResourceKey<Enchantment>)Enchantments.INFINITY, 3);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.ANTIGRAVITY, 2);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.NOGRAVITY, 2);
        MafishCrossbowEnchantSelector.addEnchantOption(pool, (HolderGetter<Enchantment>)lookup, ModEnchantments.NORESISTANCE, 3);
        if (pool.isEmpty()) {
            return List.of();
        }
        ArrayList<EnchantOption> result = new ArrayList<EnchantOption>();
        HashSet<ResourceKey> selectedKeys = new HashSet<ResourceKey>();
        Collections.shuffle(pool);
        for (EnchantOption option : pool) {
            ResourceKey key = option.holder.getKey();
            if (!selectedKeys.contains(key)) {
                if (curseMode) {
                    int maxLevel = ((Enchantment)option.holder.value()).getMaxLevel();
                    Holder<Enchantment> curseHolder = MafishCrossbowEnchantSelector.getRandomCurse((HolderGetter<Enchantment>)lookup, player.getRandom());
                    result.add(new EnchantOption(option.holder, maxLevel, curseHolder));
                } else {
                    result.add(option);
                }
                selectedKeys.add(key);
            }
            if (result.size() < 3) continue;
            break;
        }
        return result;
    }

    private static void addEnchantOption(List<EnchantOption> pool, HolderGetter<Enchantment> lookup, ResourceKey<Enchantment> key, int rarity) {
        lookup.get(key).ifPresent(holder -> {
            for (int i = 0; i < 4 - rarity; ++i) {
                pool.add(new EnchantOption((Holder<Enchantment>)holder));
            }
        });
    }

    private static Holder<Enchantment> getRandomCurse(HolderGetter<Enchantment> lookup, RandomSource random) {
        ResourceKey<Enchantment> curseKey = CURSE_ENCHANTS.get(random.nextInt(CURSE_ENCHANTS.size()));
        return (Holder)lookup.get(curseKey).orElseThrow();
    }

    public static void applyChoice(Player player, int choice) {
        UUID uuid = player.getUUID();
        List<EnchantOption> options = pendingChoices.get(uuid);
        if (options == null || choice < 1 || choice > options.size()) {
            return;
        }
        int points = (Integer)player.getData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS);
        if (points <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.insufficient_points", (Object[])new Object[]{0}), false);
            pendingChoices.remove(uuid);
            curseMode.remove(uuid);
            pendingCurseEvent.remove(uuid);
            return;
        }
        ItemStack mainHandCrossbow = player.getMainHandItem();
        if (mainHandCrossbow.getItem() != Items.CROSSBOW) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.need_hold_crossbow"), false);
            pendingChoices.remove(uuid);
            curseMode.remove(uuid);
            pendingCurseEvent.remove(uuid);
            return;
        }
        EnchantOption selected = options.get(choice - 1);
        boolean isCurseMode = curseMode.getOrDefault(uuid, false);
        if (isCurseMode && selected.curseHolder != null) {
            int mainLevel = selected.forcedLevel;
            mainHandCrossbow.enchant(selected.holder, mainLevel);
            int curseLevel = ((Enchantment)selected.curseHolder.value()).getMaxLevel();
            mainHandCrossbow.enchant(selected.curseHolder, curseLevel);
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.enchant_success", (Object[])new Object[]{((Enchantment)selected.holder.value()).description().copy().append(" \u00a77+ ").append(((Enchantment)selected.curseHolder.value()).description()), mainLevel, points - 1}), false);
            player.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
            player.playSound(SoundEvents.WITHER_HURT, 0.5f, 1.2f);
        } else {
            Holder<Enchantment> holder = selected.holder;
            int currentLevel = mainHandCrossbow.getEnchantmentLevel(holder);
            int maxLevel = ((Enchantment)holder.value()).getMaxLevel();
            int newLevel = Math.min(currentLevel + 1, maxLevel);
            mainHandCrossbow.enchant(holder, newLevel);
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.enchant_success", (Object[])new Object[]{((Enchantment)holder.value()).description(), newLevel, points - 1}), false);
            player.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        }
        player.setData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS, (Object)(points - 1));
        pendingChoices.remove(uuid);
        curseMode.remove(uuid);
        pendingCurseEvent.remove(uuid);
    }

    public static void skipChoice(Player player) {
        UUID uuid = player.getUUID();
        int points = (Integer)player.getData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS);
        pendingChoices.remove(uuid);
        curseMode.remove(uuid);
        pendingCurseEvent.remove(uuid);
        if (points > 0) {
            player.setData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS, (Object)(points - 1));
            player.displayClientMessage((Component)Component.translatable((String)"message.mafishcrossbow.rougecraft.skip_success", (Object[])new Object[]{points - 1}), false);
            player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.7f, 0.8f);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"\u00a77\u5df2\u8df3\u8fc7\u672c\u6b21\u9644\u9b54\u9009\u62e9"), false);
        }
    }

    public static void onRunStart(Player player) {
        UUID uuid = player.getUUID();
        playerKills.put(uuid, 0);
        player.setData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS, (Object)0);
        lastLevel.remove(uuid);
        pendingChoices.remove(uuid);
        curseMode.remove(uuid);
        pendingCurseEvent.remove(uuid);
        ItemStack mafishCrossbow = MafishCrossbowEnchantSelector.createMafishCrossbow();
        if (!player.getInventory().add(mafishCrossbow)) {
            player.drop(mafishCrossbow, false);
        }
        ItemStack arrows = new ItemStack((ItemLike)Items.ARROW, 5);
        if (!player.getInventory().add(arrows)) {
            player.drop(arrows, false);
        }
    }

    public static void onRunEnd(Player player) {
        UUID uuid = player.getUUID();
        playerKills.remove(uuid);
        lastLevel.remove(uuid);
        pendingChoices.remove(uuid);
        curseMode.remove(uuid);
        pendingCurseEvent.remove(uuid);
        player.setData(ModAttachments.ROUGECRAFT_ENCHANT_POINTS, (Object)0);
    }

    private static class EnchantOption {
        Holder<Enchantment> holder;
        int forcedLevel;
        Holder<Enchantment> curseHolder;

        EnchantOption(Holder<Enchantment> holder) {
            this.holder = holder;
            this.forcedLevel = 0;
            this.curseHolder = null;
        }

        EnchantOption(Holder<Enchantment> holder, int forcedLevel, Holder<Enchantment> curseHolder) {
            this.holder = holder;
            this.forcedLevel = forcedLevel;
            this.curseHolder = curseHolder;
        }
    }
}

