/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.integration;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.item.ModItems;
import com.mafuyu33.mafishcrossbow.rougecraft.integration.RoguecraftIntegration;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetManager;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetSavedData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.PresetCrossbowRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RoguecraftLootGenerator {
    public static void onMobKilled(Entity mob, Player player) {
        if (!RoguecraftIntegration.isInRun(player)) {
            return;
        }
        Level level = mob.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack projectile = RoguecraftLootGenerator.createProjectileStack(player);
        mob.spawnAtLocation(serverLevel, projectile, 0.0f);
        ItemStack specialLoot = RoguecraftLootGenerator.generateSpecialLoot(player);
        mob.spawnAtLocation(serverLevel, specialLoot, 0.0f);
        player.displayClientMessage((Component)Component.literal((String)"\u2605 ").withStyle(ChatFormatting.GOLD).append(specialLoot.getHoverName()), true);
    }

    private static ItemStack generateSpecialLoot(Player player) {
        int roll = player.getRandom().nextInt(100);
        if (roll < 90) {
            return RoguecraftLootGenerator.createPresetLoadedCrossbow(player);
        }
        if (roll < 95) {
            return RoguecraftLootGenerator.createEnchantedCrossbow(player);
        }
        return RoguecraftLootGenerator.createEnchantedTurret(player);
    }

    private static ItemStack createProjectileStack(Player player) {
        List<WeightedItem> pool = RoguecraftLootGenerator.getAllProjectilePool();
        WeightedItem selected = RoguecraftLootGenerator.selectWeightedProjectile(player.getRandom(), pool);
        if (selected != null) {
            int count = selected.minCount + player.getRandom().nextInt(selected.maxCount - selected.minCount + 1);
            if (selected.item == Items.SPLASH_POTION || selected.item == Items.LINGERING_POTION) {
                return PresetCrossbowRegistry.createRandomPotion(selected.item, count, player);
            }
            return new ItemStack((ItemLike)selected.item, count);
        }
        return new ItemStack((ItemLike)Items.ARROW, 10);
    }

    private static List<WeightedItem> getAllProjectilePool() {
        ArrayList<WeightedItem> pool = new ArrayList<WeightedItem>();
        pool.add(new WeightedItem(Items.ARROW, 40, 2, 4));
        pool.add(new WeightedItem(Items.SPECTRAL_ARROW, 40, 2, 4));
        pool.add(new WeightedItem(Items.SNOWBALL, 40, 2, 4));
        pool.add(new WeightedItem(Items.EGG, 40, 2, 4));
        pool.add(new WeightedItem(Items.FIREWORK_ROCKET, 40, 2, 4));
        pool.add(new WeightedItem(Items.ENDER_PEARL, 35, 1, 2));
        pool.add(new WeightedItem(Items.BLAZE_POWDER, 35, 1, 2));
        pool.add(new WeightedItem(Items.TNT, 35, 1, 2));
        pool.add(new WeightedItem(Items.SPLASH_POTION, 35, 1, 2));
        pool.add(new WeightedItem(Items.LINGERING_POTION, 35, 1, 2));
        pool.add(new WeightedItem(Items.EXPERIENCE_BOTTLE, 35, 1, 2));
        pool.add(new WeightedItem(Items.WIND_CHARGE, 35, 1, 2));
        pool.add(new WeightedItem(Items.LIGHTNING_ROD, 25, 1, 2));
        pool.add(new WeightedItem(Items.WITHER_SKELETON_SKULL, 25, 1, 2));
        pool.add(new WeightedItem(Items.DRAGON_BREATH, 25, 1, 2));
        pool.add(new WeightedItem(Items.GHAST_TEAR, 25, 1, 2));
        pool.add(new WeightedItem(Items.ECHO_SHARD, 25, 1, 2));
        pool.add(new WeightedItem((Item)ModItems.SHULKER_BULLET.get(), 25, 1, 2));
        return pool;
    }

    private static WeightedItem selectWeightedProjectile(RandomSource random, List<WeightedItem> pool) {
        int totalWeight = pool.stream().mapToInt(item -> item.weight).sum();
        int roll = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedItem item2 : pool) {
            if (roll >= (currentWeight += item2.weight)) continue;
            return item2;
        }
        return pool.isEmpty() ? null : pool.get(0);
    }

    private static ItemStack createPresetLoadedCrossbow(Player player) {
        PresetCrossbowRegistry.PresetCrossbow fallback;
        if (player.getRandom().nextFloat() < 0.2f) {
            return RoguecraftLootGenerator.createRandomLoadedCrossbow(player);
        }
        List<PresetCrossbowRegistry.PresetCrossbow> hardcodedPresets = PresetCrossbowRegistry.getAllPresets(player);
        List<Object> userPresets = new ArrayList();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            userPresets = CrossbowPresetManager.getLootPoolPresets(serverLevel);
        }
        int totalWeight = 0;
        for (PresetCrossbowRegistry.PresetCrossbow preset : hardcodedPresets) {
            totalWeight += preset.getWeight();
        }
        if ((totalWeight += userPresets.size() * 10) == 0) {
            return ItemStack.EMPTY;
        }
        int roll = player.getRandom().nextInt(totalWeight);
        int currentWeight = 0;
        for (PresetCrossbowRegistry.PresetCrossbow presetCrossbow : hardcodedPresets) {
            if (roll >= (currentWeight += presetCrossbow.getWeight())) continue;
            return PresetCrossbowRegistry.createCrossbow(presetCrossbow, player);
        }
        for (CrossbowPresetSavedData.PresetEntry presetEntry : userPresets) {
            if (roll >= (currentWeight += 10)) continue;
            try {
                ItemStack crossbow = CrossbowPresetManager.loadPreset((ServerLevel)player.level(), presetEntry.name);
                if (crossbow == null) continue;
                MafishCrossbow.LOGGER.info("[LootGenerator] \u4ece\u7528\u6237\u9884\u8bbe\u751f\u6210\u5f29: {}", (Object)presetEntry.name);
                return crossbow;
            }
            catch (Exception e) {
                MafishCrossbow.LOGGER.error("[LootGenerator] \u52a0\u8f7d\u7528\u6237\u9884\u8bbe\u5931\u8d25: {}", (Object)presetEntry.name, (Object)e);
            }
        }
        if (!hardcodedPresets.isEmpty() && (fallback = RoguecraftLootGenerator.selectWeightedPreset(player.getRandom(), hardcodedPresets)) != null) {
            return PresetCrossbowRegistry.createCrossbow(fallback, player);
        }
        return ItemStack.EMPTY;
    }

    private static PresetCrossbowRegistry.PresetCrossbow selectWeightedPreset(RandomSource random, List<PresetCrossbowRegistry.PresetCrossbow> presets) {
        if (presets.isEmpty()) {
            return null;
        }
        int totalWeight = presets.stream().mapToInt(PresetCrossbowRegistry.PresetCrossbow::getWeight).sum();
        if (totalWeight == 0) {
            return presets.get(0);
        }
        int roll = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (PresetCrossbowRegistry.PresetCrossbow preset : presets) {
            if (roll >= (currentWeight += preset.getWeight())) continue;
            return preset;
        }
        return presets.get(0);
    }

    private static ItemStack createRandomLoadedCrossbow(Player player) {
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        String randomName = RoguecraftLootGenerator.getRandomCrossbowName(player.getRandom());
        crossbow.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)randomName).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        ItemStack randomBundle = RoguecraftLootGenerator.createRandomBundle(player);
        crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)randomBundle));
        RoguecraftLootGenerator.addRandomEnchantsWithCurse(crossbow, player);
        int randomDurability = 1;
        crossbow.set(DataComponents.MAX_DAMAGE, (Object)randomDurability);
        crossbow.set(DataComponents.DAMAGE, (Object)0);
        return crossbow;
    }

    private static ItemStack createRandomBundle(Player player) {
        ItemStack bundle = new ItemStack((ItemLike)Items.BUNDLE);
        BundleContents.Mutable contents = new BundleContents.Mutable(BundleContents.EMPTY);
        List<WeightedItem> pool = RoguecraftLootGenerator.getAllProjectilePool();
        Collections.shuffle(pool);
        int typeCount = 3 + player.getRandom().nextInt(4);
        for (int i = 0; i < Math.min(typeCount, pool.size()); ++i) {
            WeightedItem selectedType = pool.get(i);
            int count = 2 + player.getRandom().nextInt(7);
            for (int j = 0; j < count; ++j) {
                ItemStack item = selectedType.item == Items.SPLASH_POTION || selectedType.item == Items.LINGERING_POTION ? PresetCrossbowRegistry.createRandomPotion(selectedType.item, 1, player) : new ItemStack((ItemLike)selectedType.item, 1);
                contents.tryInsert(item);
            }
        }
        bundle.set(DataComponents.BUNDLE_CONTENTS, (Object)contents.toImmutable());
        RoguecraftLootGenerator.addRandomEnchantsWithCurse(bundle, player);
        return bundle;
    }

    private static String getRandomCrossbowName(RandomSource random) {
        String[] colors = new String[]{"\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e", "\u00a76", "\u00a79", "\u00a75"};
        String color = colors[random.nextInt(colors.length)];
        String[] prefixes = new String[]{"\u4f20\u8bf4", "\u53f2\u8bd7", "\u7a00\u6709", "\u795e\u79d8", "\u8fdc\u53e4", "\u7981\u5fcc", "\u5723\u6d01", "\u6697\u5f71", "\u70c8\u7130", "\u51b0\u971c", "\u96f7\u9706", "\u98ce\u66b4", "\u6bc1\u706d", "\u5b88\u62a4", "\u72c2\u66b4", "\u5e7d\u7075"};
        String prefix = prefixes[random.nextInt(prefixes.length)];
        String[] mainNames = new String[]{"\u5c04\u624b", "\u730e\u4eba", "\u6218\u58eb", "\u6cd5\u5e08", "\u523a\u5ba2", "\u6e38\u4fa0", "\u5f29\u624b", "\u72d9\u51fb\u624b", "\u6bc1\u706d\u8005", "\u5f81\u670d\u8005", "\u7ec8\u7ed3\u8005", "\u88c1\u51b3\u8005", "\u5ba1\u5224\u8005", "\u6267\u884c\u8005"};
        String mainName = mainNames[random.nextInt(mainNames.length)];
        String[] suffixes = new String[]{"\u4e4b\u5f29", "\u7684\u6b66\u5668", "\u7684\u793c\u7269", "\u7684\u9057\u7269", "\u7684\u5b9d\u85cf", "\u4e4b\u529b", "\u4e4b\u6012", "\u4e4b\u5fc3"};
        String suffix = suffixes[random.nextInt(suffixes.length)];
        String bold = random.nextFloat() < 0.3f ? "\u00a7l" : "";
        int obfuscatedPart = random.nextInt(3);
        switch (obfuscatedPart) {
            case 0: {
                return color + bold + "\u00a7kqwq\u00a7r" + color + bold + mainName + suffix;
            }
            case 1: {
                return color + bold + prefix + "\u00a7kqwq\u00a7r" + color + bold + suffix;
            }
            case 2: {
                return color + bold + prefix + mainName + "\u00a7kqwq";
            }
        }
        return color + bold + prefix + mainName + suffix;
    }

    private static ItemStack createEnchantedCrossbow(Player player) {
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        RoguecraftLootGenerator.addRandomEnchantsWithCurse(crossbow, player);
        return crossbow;
    }

    private static ItemStack createEnchantedTurret(Player player) {
        ItemStack turret = new ItemStack((ItemLike)ModItems.CROSSBOW_TURRET.get());
        RoguecraftLootGenerator.addRandomEnchantsWithCurse(turret, player);
        return turret;
    }

    private static void addRandomEnchantsWithCurse(ItemStack item, Player player) {
        HolderLookup lookup = player.level().holderLookup(Registries.ENCHANTMENT);
        int enchantCount = 1 + player.getRandom().nextInt(2);
        float curseChance = 0.35f;
        int minLevel = 2;
        int maxLevel = 3;
        HashSet<ResourceKey<Enchantment>> appliedEnchants = new HashSet<ResourceKey<Enchantment>>();
        block0: for (int i = 0; i < enchantCount; ++i) {
            boolean isCurse = player.getRandom().nextFloat() < curseChance;
            List<ResourceKey<Enchantment>> pool = isCurse ? RoguecraftLootGenerator.getCurseEnchantmentPool() : RoguecraftLootGenerator.getNormalEnchantmentPool();
            Collections.shuffle(pool);
            for (ResourceKey<Enchantment> enchantKey : pool) {
                if (appliedEnchants.contains(enchantKey)) continue;
                lookup.get(enchantKey).ifPresent(holder -> {
                    int enchantMaxLevel = ((Enchantment)holder.value()).getMaxLevel();
                    int actualMinLevel = Math.min(minLevel, enchantMaxLevel);
                    int actualMaxLevel = Math.min(maxLevel, enchantMaxLevel);
                    int range = Math.max(1, actualMaxLevel - actualMinLevel + 1);
                    int level = actualMinLevel + player.getRandom().nextInt(range);
                    item.enchant((Holder)holder, level);
                });
                appliedEnchants.add(enchantKey);
                continue block0;
            }
        }
    }

    private static List<ResourceKey<Enchantment>> getNormalEnchantmentPool() {
        ArrayList<ResourceKey<Enchantment>> pool = new ArrayList<ResourceKey<Enchantment>>();
        pool.add(ModEnchantments.TRACKING);
        pool.add(ModEnchantments.BOUNCE);
        pool.add(ModEnchantments.REDIRECT);
        pool.add(ModEnchantments.ACCELERATE);
        pool.add(ModEnchantments.INCREASE_INITIAL_SPEED);
        pool.add(ModEnchantments.INCREASE_DAMAGE);
        pool.add(ModEnchantments.INCREASE_LIFETIME);
        pool.add(Enchantments.PIERCING);
        pool.add(Enchantments.MULTISHOT);
        pool.add(Enchantments.INFINITY);
        pool.add(ModEnchantments.ANTIGRAVITY);
        pool.add(ModEnchantments.NOGRAVITY);
        pool.add(ModEnchantments.NORESISTANCE);
        return pool;
    }

    private static List<ResourceKey<Enchantment>> getCurseEnchantmentPool() {
        ArrayList<ResourceKey<Enchantment>> pool = new ArrayList<ResourceKey<Enchantment>>();
        pool.add(ModEnchantments.DECREASE_INITIAL_SPEED);
        pool.add(ModEnchantments.DECREASE_LIFETIME);
        pool.add(ModEnchantments.DECREASE_DAMAGE);
        pool.add(ModEnchantments.LEAKY);
        pool.add(ModEnchantments.BOWLEFT);
        pool.add(ModEnchantments.BOWRIGHT);
        pool.add(ModEnchantments.BAD_LUCK_OF_SEA);
        pool.add(ModEnchantments.MISFIRE);
        pool.add(ModEnchantments.BORE_BURST);
        pool.add(ModEnchantments.INTANGIBLE);
        return pool;
    }

    private static class WeightedItem {
        final Item item;
        final int weight;
        final int minCount;
        final int maxCount;

        WeightedItem(Item item, int weight, int minCount, int maxCount) {
            this.item = item;
            this.weight = weight;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }
    }
}

