/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.network;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.rougecraft.integration.MafishCrossbowEnchantSelector;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EnchantmentChoiceC2SPacket(int choice) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnchantmentChoiceC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"enchantment_choice"));
    public static final StreamCodec<FriendlyByteBuf, EnchantmentChoiceC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentChoiceC2SPacket::choice, EnchantmentChoiceC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EnchantmentChoiceC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (payload.choice() < 1 || payload.choice() > 3) {
                    MafishCrossbow.LOGGER.warn("Player {} sent invalid enchantment choice: {}", (Object)player.getName().getString(), (Object)payload.choice());
                    return;
                }
                MafishCrossbowEnchantSelector.applyChoice((Player)player, payload.choice());
            }
        });
    }
}

