/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.BundleProjectileData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.CrossbowPresetData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.CrossbowProjectileData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.EnchantmentData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.ProjectileData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.SimpleProjectileData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrossbowPresetCodec {
    private static final String PREFIX = "MCXB1:";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static String encode(ItemStack crossbow, Level level) {
        if (!(crossbow.getItem() instanceof CrossbowItem)) {
            throw new IllegalArgumentException("Item is not a crossbow");
        }
        try {
            CrossbowPresetData data = CrossbowPresetCodec.extractData(crossbow, level);
            String json = GSON.toJson((JsonElement)data.toJson());
            byte[] compressed = CrossbowPresetCodec.gzipCompress(json.getBytes(StandardCharsets.UTF_8));
            String base64 = Base64.getUrlEncoder().withoutPadding().encodeToString(compressed);
            return PREFIX + base64;
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("Failed to encode crossbow", (Throwable)e);
            throw new RuntimeException("Failed to encode crossbow", e);
        }
    }

    public static ItemStack decode(String encoded, Level level) {
        if (!encoded.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Invalid preset string: missing prefix");
        }
        try {
            String base64 = encoded.substring(PREFIX.length());
            byte[] compressed = Base64.getUrlDecoder().decode(base64);
            MafishCrossbow.LOGGER.info("[Decode] Base64\u89e3\u7801\u6210\u529f, \u538b\u7f29\u6570\u636e\u957f\u5ea6: {} bytes", (Object)compressed.length);
            String json = new String(CrossbowPresetCodec.gzipDecompress(compressed), StandardCharsets.UTF_8);
            MafishCrossbow.LOGGER.info("[Decode] GZIP\u89e3\u538b\u6210\u529f, JSON: {}", (Object)json);
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            MafishCrossbow.LOGGER.info("[Decode] JSON\u89e3\u6790\u6210\u529f");
            CrossbowPresetData data = CrossbowPresetData.fromJson(jsonObject);
            MafishCrossbow.LOGGER.info("[Decode] CrossbowPresetData\u89e3\u6790\u6210\u529f: name={}, enchants={}, projectiles={}", new Object[]{data.name(), data.enchantments().size(), data.projectiles().size()});
            ItemStack result = CrossbowPresetCodec.buildItemStack(data, level);
            MafishCrossbow.LOGGER.info("[Decode] ItemStack\u91cd\u5efa\u6210\u529f");
            return result;
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("Failed to decode crossbow preset", (Throwable)e);
            throw new RuntimeException("Failed to decode crossbow preset: " + e.getMessage(), e);
        }
    }

    public static String decodeToJson(String encoded) {
        if (!encoded.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Invalid preset string: missing prefix");
        }
        try {
            String base64 = encoded.substring(PREFIX.length());
            byte[] compressed = Base64.getUrlDecoder().decode(base64);
            return new String(CrossbowPresetCodec.gzipDecompress(compressed), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode to JSON: " + e.getMessage(), e);
        }
    }

    public static boolean isValidEncoded(String str) {
        if (str == null || !str.startsWith(PREFIX)) {
            return false;
        }
        try {
            String base64 = str.substring(PREFIX.length());
            Base64.getUrlDecoder().decode(base64);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static CrossbowPresetData extractData(ItemStack crossbow, Level level) {
        String name = null;
        Component customName = (Component)crossbow.get(DataComponents.CUSTOM_NAME);
        if (customName != null) {
            name = customName.getString();
        }
        List<EnchantmentData> enchantments = CrossbowPresetCodec.extractEnchantments(crossbow);
        ArrayList<ProjectileData> projectiles = new ArrayList<ProjectileData>();
        ChargedProjectiles charged = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (charged != null) {
            LinkedHashMap<CallSite, SimpleProjectileData> mergedProjectiles = new LinkedHashMap<CallSite, SimpleProjectileData>();
            for (ItemStack ammo : charged.getItems()) {
                ProjectileData projData = CrossbowPresetCodec.extractProjectile(ammo, level);
                if (projData instanceof SimpleProjectileData) {
                    SimpleProjectileData simple = (SimpleProjectileData)projData;
                    String key = simple.itemId() + "|" + simple.potionId() + "|" + simple.enchantments().hashCode();
                    if (mergedProjectiles.containsKey(key)) {
                        SimpleProjectileData existing = (SimpleProjectileData)mergedProjectiles.get(key);
                        mergedProjectiles.put((CallSite)((Object)key), new SimpleProjectileData(simple.itemId(), existing.count() + simple.count(), simple.enchantments(), simple.potionId()));
                        continue;
                    }
                    mergedProjectiles.put((CallSite)((Object)key), simple);
                    continue;
                }
                projectiles.add(projData);
            }
            projectiles.addAll(0, mergedProjectiles.values());
        }
        return new CrossbowPresetData(name, enchantments, projectiles);
    }

    private static List<EnchantmentData> extractEnchantments(ItemStack item) {
        ArrayList<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
        ItemEnchantments itemEnchantments = (ItemEnchantments)item.get(DataComponents.ENCHANTMENTS);
        if (itemEnchantments != null) {
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                int level = entry.getIntValue();
                ResourceLocation enchantId = holder.unwrapKey().map(key -> key.location()).orElse(null);
                if (enchantId == null) continue;
                enchantments.add(new EnchantmentData(enchantId.toString(), level));
            }
        }
        return enchantments;
    }

    private static ProjectileData extractProjectile(ItemStack item, Level level) {
        MafishCrossbow.LOGGER.info("[extractProjectile] \u5904\u7406\u7269\u54c1: {}, \u6570\u91cf: {}", (Object)item.getItem(), (Object)item.getCount());
        if (item.getItem() instanceof CrossbowItem) {
            MafishCrossbow.LOGGER.info("[extractProjectile] \u68c0\u6d4b\u5230\u5d4c\u5957\u5f29");
            CrossbowPresetData nestedData = CrossbowPresetCodec.extractData(item, level);
            return new CrossbowProjectileData(nestedData);
        }
        BundleContents bundleContents = (BundleContents)item.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents != null && !bundleContents.isEmpty()) {
            MafishCrossbow.LOGGER.info("[extractProjectile] \u68c0\u6d4b\u5230\u6536\u7eb3\u888b, \u5305\u542b {} \u4e2a\u7269\u54c1", (Object)bundleContents.size());
            ArrayList<ProjectileData> contents = new ArrayList<ProjectileData>();
            LinkedHashMap<CallSite, SimpleProjectileData> mergedContents = new LinkedHashMap<CallSite, SimpleProjectileData>();
            for (ItemStack content : bundleContents.items()) {
                ProjectileData projData = CrossbowPresetCodec.extractProjectile(content, level);
                if (projData instanceof SimpleProjectileData) {
                    SimpleProjectileData simple = (SimpleProjectileData)projData;
                    String key2 = simple.itemId() + "|" + simple.potionId();
                    if (mergedContents.containsKey(key2)) {
                        SimpleProjectileData existing = (SimpleProjectileData)mergedContents.get(key2);
                        mergedContents.put((CallSite)((Object)key2), new SimpleProjectileData(simple.itemId(), existing.count() + simple.count(), simple.enchantments(), simple.potionId()));
                        continue;
                    }
                    mergedContents.put((CallSite)((Object)key2), simple);
                    continue;
                }
                contents.add(projData);
            }
            contents.addAll(0, mergedContents.values());
            List<EnchantmentData> bundleEnchants = CrossbowPresetCodec.extractEnchantments(item);
            return new BundleProjectileData(contents, bundleEnchants);
        }
        String itemId = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString();
        String potionId = null;
        PotionContents potionContents = (PotionContents)item.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null && potionContents.potion().isPresent()) {
            Holder potionHolder = (Holder)potionContents.potion().get();
            potionId = potionHolder.unwrapKey().map(key -> key.location().toString()).orElse(null);
        }
        List<EnchantmentData> itemEnchants = CrossbowPresetCodec.extractEnchantments(item);
        return new SimpleProjectileData(itemId, item.getCount(), itemEnchants, potionId);
    }

    private static ItemStack buildItemStack(CrossbowPresetData data, Level level) {
        MafishCrossbow.LOGGER.info("[buildItemStack] \u5f00\u59cb\u6784\u5efa\u5f29, \u540d\u79f0={}, \u9644\u9b54\u6570={}, \u6295\u5c04\u7269\u6570={}", new Object[]{data.name(), data.enchantments().size(), data.projectiles().size()});
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        if (data.name() != null && !data.name().isEmpty()) {
            crossbow.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)data.name()).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
            MafishCrossbow.LOGGER.info("[buildItemStack] \u8bbe\u7f6e\u540d\u79f0: {}", (Object)data.name());
        }
        CrossbowPresetCodec.applyEnchantments(crossbow, data.enchantments(), level);
        ArrayList<ItemStack> ammoList = new ArrayList<ItemStack>();
        for (int i = 0; i < data.projectiles().size(); ++i) {
            ProjectileData proj = data.projectiles().get(i);
            MafishCrossbow.LOGGER.info("[buildItemStack] \u5904\u7406\u6295\u5c04\u7269 {}/{}, \u7c7b\u578b={}", new Object[]{i + 1, data.projectiles().size(), proj.getType()});
            try {
                SimpleProjectileData simple;
                ItemStack projStack = CrossbowPresetCodec.buildProjectile(proj, level);
                if (proj instanceof SimpleProjectileData && (simple = (SimpleProjectileData)proj).count() > 1) {
                    for (int j = 0; j < simple.count(); ++j) {
                        ammoList.add(projStack.copyWithCount(1));
                    }
                } else {
                    ammoList.add(projStack);
                }
                MafishCrossbow.LOGGER.info("[buildItemStack] \u6295\u5c04\u7269 {} \u6784\u5efa\u6210\u529f: {}", (Object)(i + 1), (Object)projStack.getItem());
                continue;
            }
            catch (Exception e) {
                MafishCrossbow.LOGGER.error("[buildItemStack] \u6295\u5c04\u7269 {} \u6784\u5efa\u5931\u8d25", (Object)(i + 1), (Object)e);
                throw e;
            }
        }
        crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(ammoList));
        MafishCrossbow.LOGGER.info("[buildItemStack] \u88c5\u8f7d\u4e86 {} \u4e2a\u6295\u5c04\u7269", (Object)ammoList.size());
        crossbow.set(DataComponents.MAX_DAMAGE, (Object)1);
        crossbow.set(DataComponents.DAMAGE, (Object)0);
        crossbow = CrossbowPresetCodec.ensureInfinityEnchantment(crossbow, level);
        return crossbow;
    }

    private static ItemStack ensureInfinityEnchantment(ItemStack crossbow, Level level) {
        ItemEnchantments enchantments = (ItemEnchantments)crossbow.get(DataComponents.ENCHANTMENTS);
        boolean hasInfinity = false;
        if (enchantments != null) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                ResourceLocation enchantId = ((Holder)entry.getKey()).unwrapKey().map(key -> key.location()).orElse(null);
                if (enchantId == null || !enchantId.toString().equals("minecraft:infinity")) continue;
                hasInfinity = true;
                break;
            }
        }
        if (!hasInfinity) {
            ResourceKey infinityKey;
            HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
            Optional optionalHolder = lookup.get(infinityKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"infinity")));
            if (optionalHolder.isPresent()) {
                crossbow.enchant((Holder)optionalHolder.get(), 1);
                MafishCrossbow.LOGGER.info("[ensureInfinityEnchantment] \u81ea\u52a8\u6dfb\u52a0\u65e0\u9650\u9644\u9b54");
            } else {
                MafishCrossbow.LOGGER.warn("[ensureInfinityEnchantment] \u627e\u4e0d\u5230\u65e0\u9650\u9644\u9b54");
            }
        }
        return crossbow;
    }

    private static ItemStack buildProjectile(ProjectileData data, Level level) {
        MafishCrossbow.LOGGER.info("[buildProjectile] \u5904\u7406\u7c7b\u578b: {}", (Object)data.getType());
        ProjectileData projectileData = data;
        Objects.requireNonNull(projectileData);
        ProjectileData projectileData2 = projectileData;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleProjectileData.class, CrossbowProjectileData.class, BundleProjectileData.class}, (Object)projectileData2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ItemStack var4_18;
                SimpleProjectileData simple = (SimpleProjectileData)projectileData2;
                MafishCrossbow.LOGGER.info("[buildProjectile] Simple: itemId={}, count={}", (Object)simple.itemId(), (Object)simple.count());
                ResourceLocation itemLoc = ResourceLocation.parse((String)simple.itemId());
                Item item = (Item)BuiltInRegistries.ITEM.getValue(itemLoc);
                if (item == Items.AIR) {
                    MafishCrossbow.LOGGER.warn("[buildProjectile] \u627e\u4e0d\u5230\u7269\u54c1: {}, \u4f7f\u7528\u9ed8\u8ba4\u7bad\u77e2", (Object)simple.itemId());
                    item = Items.ARROW;
                }
                ItemStack stack = new ItemStack((ItemLike)item, 1);
                if (simple.enchantments() != null && !simple.enchantments().isEmpty()) {
                    CrossbowPresetCodec.applyEnchantments(stack, simple.enchantments(), level);
                }
                if (simple.potionId() != null) {
                    MafishCrossbow.LOGGER.info("[buildProjectile] \u5c1d\u8bd5\u5e94\u7528\u836f\u6c34: {}", (Object)simple.potionId());
                    try {
                        ResourceLocation potionLoc = ResourceLocation.parse((String)simple.potionId());
                        Potion potion = (Potion)BuiltInRegistries.POTION.getValue(potionLoc);
                        if (potion != null) {
                            Holder potionHolder = BuiltInRegistries.POTION.wrapAsHolder((Object)potion);
                            stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionHolder));
                            MafishCrossbow.LOGGER.info("[buildProjectile] \u836f\u6c34\u5e94\u7528\u6210\u529f: {}", (Object)simple.potionId());
                        } else {
                            MafishCrossbow.LOGGER.warn("[buildProjectile] \u627e\u4e0d\u5230\u836f\u6c34: {}", (Object)simple.potionId());
                        }
                    }
                    catch (Exception e) {
                        MafishCrossbow.LOGGER.error("[buildProjectile] \u5e94\u7528\u836f\u6c34\u5931\u8d25: {}", (Object)simple.potionId(), (Object)e);
                    }
                }
                yield var4_18 = stack;
            }
            case 1 -> {
                ItemStack var4_19;
                CrossbowProjectileData nested = (CrossbowProjectileData)projectileData2;
                yield var4_19 = CrossbowPresetCodec.buildItemStack(nested.nestedCrossbow(), level);
            }
            case 2 -> {
                ItemStack var4_20;
                BundleProjectileData bundle = (BundleProjectileData)projectileData2;
                MafishCrossbow.LOGGER.info("[buildProjectile] Bundle: contents={}, enchants={}", (Object)bundle.contents().size(), (Object)(bundle.enchantments() != null ? bundle.enchantments().size() : 0));
                ItemStack bundleStack = new ItemStack((ItemLike)Items.BUNDLE);
                BundleContents.Mutable contents = new BundleContents.Mutable(BundleContents.EMPTY);
                for (ProjectileData content : bundle.contents()) {
                    ItemStack contentStack = CrossbowPresetCodec.buildProjectile(content, level);
                    int count = 1;
                    if (content instanceof SimpleProjectileData) {
                        SimpleProjectileData simple = (SimpleProjectileData)content;
                        count = simple.count();
                    }
                    for (int i = 0; i < count; ++i) {
                        contents.tryInsert(contentStack.copyWithCount(1));
                    }
                }
                bundleStack.set(DataComponents.BUNDLE_CONTENTS, (Object)contents.toImmutable());
                if (bundle.enchantments() != null && !bundle.enchantments().isEmpty()) {
                    CrossbowPresetCodec.applyEnchantments(bundleStack, bundle.enchantments(), level);
                }
                yield var4_20 = bundleStack;
            }
        };
    }

    private static void applyEnchantments(ItemStack item, List<EnchantmentData> enchantments, Level level) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
        for (EnchantmentData enchData : enchantments) {
            ResourceLocation enchLoc = ResourceLocation.parse((String)enchData.id());
            ResourceKey enchKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchLoc);
            Optional optionalHolder = lookup.get(enchKey);
            if (optionalHolder.isPresent()) {
                item.enchant((Holder)optionalHolder.get(), enchData.level());
                MafishCrossbow.LOGGER.info("[applyEnchantments] \u5e94\u7528\u9644\u9b54: {} lv{}", (Object)enchData.id(), (Object)enchData.level());
                continue;
            }
            MafishCrossbow.LOGGER.warn("[applyEnchantments] \u627e\u4e0d\u5230\u9644\u9b54: {}", (Object)enchData.id());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] gzipCompress(byte[] data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                gzos.write(data);
                gzos.finish();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("GZIP compression failed", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] gzipDecompress(byte[] compressed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

