/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetCodec;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetSavedData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CrossbowPresetManager {
    private static final Map<UUID, StringBuilder> playerBuffers = new ConcurrentHashMap<UUID, StringBuilder>();

    public static void appendToBuffer(UUID playerId, String fragment) {
        playerBuffers.computeIfAbsent(playerId, k -> new StringBuilder()).append(fragment);
        MafishCrossbow.LOGGER.info("[PresetManager] \u73a9\u5bb6 {} \u8ffd\u52a0\u7247\u6bb5, \u5f53\u524d\u7f13\u51b2\u533a\u957f\u5ea6: {}", (Object)playerId, (Object)playerBuffers.get(playerId).length());
    }

    public static String getBuffer(UUID playerId) {
        StringBuilder buffer = playerBuffers.get(playerId);
        return buffer != null ? buffer.toString() : "";
    }

    public static int getBufferLength(UUID playerId) {
        StringBuilder buffer = playerBuffers.get(playerId);
        return buffer != null ? buffer.length() : 0;
    }

    public static void clearBuffer(UUID playerId) {
        playerBuffers.remove(playerId);
        MafishCrossbow.LOGGER.info("[PresetManager] \u73a9\u5bb6 {} \u7f13\u51b2\u533a\u5df2\u6e05\u7a7a", (Object)playerId);
    }

    public static boolean hasBuffer(UUID playerId) {
        StringBuilder buffer = playerBuffers.get(playerId);
        return buffer != null && buffer.length() > 0;
    }

    public static void savePreset(ServerLevel level, String name, String encodedString, boolean addToLootPool) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        data.savePreset(name, encodedString, addToLootPool);
    }

    public static ItemStack loadPreset(ServerLevel level, String name) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        CrossbowPresetSavedData.PresetEntry entry = data.getPreset(name);
        if (entry == null) {
            return null;
        }
        try {
            return CrossbowPresetCodec.decode(entry.encodedString, (Level)level);
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("[PresetManager] \u89e3\u7801\u9884\u8bbe\u5931\u8d25: {}", (Object)name, (Object)e);
            return null;
        }
    }

    public static String getPresetEncodedString(ServerLevel level, String name) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        CrossbowPresetSavedData.PresetEntry entry = data.getPreset(name);
        return entry != null ? entry.encodedString : null;
    }

    public static boolean deletePreset(ServerLevel level, String name) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.removePreset(name);
    }

    public static Set<String> getAllPresetNames(ServerLevel level) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.getAllPresetNames();
    }

    public static Collection<CrossbowPresetSavedData.PresetEntry> getAllPresets(ServerLevel level) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.getAllPresets();
    }

    public static List<CrossbowPresetSavedData.PresetEntry> getLootPoolPresets(ServerLevel level) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.getLootPoolPresets();
    }

    public static boolean hasPreset(ServerLevel level, String name) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.hasPreset(name);
    }

    public static int getPresetCount(ServerLevel level) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.getPresetCount();
    }

    public static boolean setLootPoolStatus(ServerLevel level, String name, boolean addToLootPool) {
        CrossbowPresetSavedData data = CrossbowPresetSavedData.get(level);
        return data.setLootPoolStatus(name, addToLootPool);
    }

    public static ItemStack getRandomLootPoolCrossbow(ServerLevel level, Random random) {
        List<CrossbowPresetSavedData.PresetEntry> lootPresets = CrossbowPresetManager.getLootPoolPresets(level);
        if (lootPresets.isEmpty()) {
            return null;
        }
        CrossbowPresetSavedData.PresetEntry selected = lootPresets.get(random.nextInt(lootPresets.size()));
        try {
            return CrossbowPresetCodec.decode(selected.encodedString, (Level)level);
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("[PresetManager] \u4ece\u6389\u843d\u6c60\u89e3\u7801\u9884\u8bbe\u5931\u8d25: {}", (Object)selected.name, (Object)e);
            return null;
        }
    }
}

