/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class CrossbowPresetSavedData
extends SavedData {
    private Map<String, PresetEntry> presets = new LinkedHashMap<String, PresetEntry>();
    public static final Codec<PresetEntry> PRESET_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.STRING.fieldOf("encoded").forGetter(e -> e.encodedString), (App)Codec.LONG.fieldOf("created").forGetter(e -> e.createdTime), (App)Codec.BOOL.fieldOf("loot").forGetter(e -> e.addToLootPool)).apply((Applicative)instance, PresetEntry::new));
    public static final Codec<CrossbowPresetSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, PRESET_ENTRY_CODEC).fieldOf("presets").forGetter(data -> data.presets)).apply((Applicative)instance, CrossbowPresetSavedData::new));
    public static final SavedDataType<CrossbowPresetSavedData> TYPE = new SavedDataType("mafishcrossbow_crossbow_presets", CrossbowPresetSavedData::new, CODEC, DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);

    public CrossbowPresetSavedData() {
        this.presets = new LinkedHashMap<String, PresetEntry>();
    }

    private CrossbowPresetSavedData(Map<String, PresetEntry> presets) {
        this.presets = new LinkedHashMap<String, PresetEntry>(presets);
    }

    public static CrossbowPresetSavedData get(ServerLevel level) {
        return (CrossbowPresetSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public void savePreset(String name, String encodedString, boolean addToLootPool) {
        this.presets.put(name, new PresetEntry(name, encodedString, System.currentTimeMillis(), addToLootPool));
        this.setDirty();
        MafishCrossbow.LOGGER.info("[PresetSavedData] \u4fdd\u5b58\u9884\u8bbe: {}, \u52a0\u5165\u6389\u843d\u6c60: {}", (Object)name, (Object)addToLootPool);
    }

    public PresetEntry getPreset(String name) {
        return this.presets.get(name);
    }

    public boolean removePreset(String name) {
        PresetEntry removed = this.presets.remove(name);
        if (removed != null) {
            this.setDirty();
            MafishCrossbow.LOGGER.info("[PresetSavedData] \u5220\u9664\u9884\u8bbe: {}", (Object)name);
            return true;
        }
        return false;
    }

    public Set<String> getAllPresetNames() {
        return new LinkedHashSet<String>(this.presets.keySet());
    }

    public Collection<PresetEntry> getAllPresets() {
        return new ArrayList<PresetEntry>(this.presets.values());
    }

    public List<PresetEntry> getLootPoolPresets() {
        ArrayList<PresetEntry> result = new ArrayList<PresetEntry>();
        for (PresetEntry entry : this.presets.values()) {
            if (!entry.addToLootPool) continue;
            result.add(entry);
        }
        return result;
    }

    public boolean hasPreset(String name) {
        return this.presets.containsKey(name);
    }

    public int getPresetCount() {
        return this.presets.size();
    }

    public boolean setLootPoolStatus(String name, boolean addToLootPool) {
        PresetEntry entry = this.presets.get(name);
        if (entry != null) {
            this.presets.put(name, new PresetEntry(entry.name, entry.encodedString, entry.createdTime, addToLootPool));
            this.setDirty();
            return true;
        }
        return false;
    }

    public static class PresetEntry {
        public final String name;
        public final String encodedString;
        public final long createdTime;
        public final boolean addToLootPool;

        public PresetEntry(String name, String encodedString, long createdTime, boolean addToLootPool) {
            this.name = name;
            this.encodedString = encodedString;
            this.createdTime = createdTime;
            this.addToLootPool = addToLootPool;
        }
    }
}

