/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class PresetCrossbowRegistry {
    private static final List<PresetConfig> PRESET_CONFIGS = List.of(new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno2dfHTDS1P1816OmHi0z0rlXSUUpWsoquVMoFyuZl5qclFiWklVrmlOSWZxRn5JUD5HCUrQ4NaHaiSxDSgeHJRfnFxUn65VVFqSmZRajJUmXFtrI5SAdi4EqDaYqAoqrGJRUX55UDRZCUrI8Pa2FoAjSq75ZMAAAA", 10, "\u6563\u5c04\u5f29"), new PresetConfig("MCXB1:H4sIAAAAAAAA_3WOQQrCMBBF7zLrbBRxkatIKWk6rQNxUpJBkdJFXYhX8QCCgh6n5BqGijvdvv8e_B4YNEyPVxpv6XJOp_v0vIICBL3pgfK2Mw3FrQ0-xsofdI02oIlYEpOQcWXsEOtcONDLQf1siMVwS5XDj7f447Fvg9mTHL9aoaCbj0iWY6ZzRJw_mEa0sGRmQa9XQzG8AWq5i-DLAAAA", 10, "\u7075\u9b42\u7206\u70b8\u5f29"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUnqxf--LHauez9__Yu-yp3tWKukopSpZRVcrZQLlchPTMoszkovyi4uT8sutSooSk7Mz89KBanKUrAxrY3WUCsBqS4Bqi4GiYD2ZeanJRYlpJVZgVmJRCVAiGay8FgCTHZzqcgAAAA", 10, "\u8ffd\u8e2a\u77ff\u8f66\u5f29"), new PresetConfig("MCXB1:H4sIAAAAAAAA_3WQTQ6CQAyF79I1C4XoYq5iCBmgQAMWMzORGMJFdOvGE7jwPJp4C4v4RyKZ2XT6vel7bYFBwfV4uh_Ot8teLniAoFYtkDTWxJgYnTlFnBGT20m7AjXvvBegM7JFYmpr47pRqdCoLUY9S7qK7AYxHTSLCY1mR7nR2-_nswmS2GnOKa7w7SL0YPM064SO5TX5VFaqcYSMDDa1KSNTJyW6gfb7Wf_5ivLCMXEugnSgl34_8mc_Y4OjGMF0jOklBV0o5wExlGhIlgEAAA", 10, "\u5929\u96f7\u6eda\u6eda"), new PresetConfig("MCXB1:H4sIAAAAAAAA_3WOMQ7CMAxF7-I5A2XMVVBVJcEBS2lSxREVVB0QA0y9AgfgXCjXIBSVrfL07afnP4AHCfn2yNdXvk_v6QkCEORuACqHVlnio4mBWYde-nCI6kTpXCAHshrFChaRiZPyBheyFtDN2lR4Xbbmn7ik2UIeTVQ2Se3UBZsu9HuMP7Tafg2rxcibiIqxcWQxUbu83Yx1mQ86jT085QAAAA", 10, "\u70c8\u706b\u71ce\u539f"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUnratuHlnDlPdnY_3bNSSUcpVckqulopEyiRm5mXmlyUmFZilVaUX1wSX56Yk51aBFSSo2RlVBuro1QAVloCVFoMFEXVUpyXX56UmJMDlEhWsjKsja0FAMV4ZNtuAAAA", 10, "\u51b0\u971c\u5f29"), new PresetConfig("MCXB1:H4sIAAAAAAAA_4WQTQrCQAxG75J1F-pyriKlzEzTGpxOZSbVRelaENwLLlx7B6-j4C2MLRUEf8gqHy-PJC14UHDf7q-74-1wggQQ1LwFkrTSBcWFDXWMpt4oDtouyZfCOFCzLk1g1bMsrJHUvjorXQ6q7eXXy_mXlrwNqCNmjgpkqnDwTydd8pHP0aLDoPkfSJ61L8m4EfwuHBYgT0zaZXGFmL_kb2dGiXsFeZnSBavIobHcBMzWNeXDF6Zd2j3nvt5sauFNEyKPq6VSD3qYcKSMAQAA", 10, "\u91cd\u529b\u661f"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUnq-cv_Lhv6X8zc_27xISUcpVckqulopEyiRm5iWWZyRXJRfXJyUX26VmVeSmJeemZSTClSVo2RlWKuDQ11yUWpicWp8SmJuYjpUsREhxZl5mSWZiTnxxQWpqSkQPaa1sTpKBWDnlAB1FgNFwSZk5qUmFyWmlVilJmfkxxdnJBaBNCSDXBRbCwBO7Z-A1AAAAA", 10, "\u7a7f\u900f\u97f3\u6ce2"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno6YcLT_sXPNmxR0lFKVbKKjtVRKgBS1UolQMlioGAmkM7NzEtNLkpMK7FKz0gsLokvSU0sAkolK1kZ1sbWAgB0jI_RSQAAAA", 10, "\u5410\u53e3\u6c34"), new PresetConfig("MCXB1:H4sIAAAAAAAA_42OOw7CMBBE77J1mkCDfBUUWf5sxCrBjtZGKaLUiBIabkFNw23IPXAShChQRDm782amAwcCnvfjcDoPj8twu0IGCGLbAaXHXpUUdoZ9CNq3wqJhVAElOYqkahkaRJuIGsSqLzJoJjImUqer-aiQ1JRHLkWoMoqSGFvPlWRvKoyzO--z_-jIZNG9qc3YvLQZa2QVcd65Hjt--BhtmmTi7Mr7YjFVe0apDxy-_f0L2xpcsk4BAAA", 10, "\u4e07\u5251\u5f52\u5b97"), new PresetConfig("MCXB1:H4sIAAAAAAAA_62UQW7DIBBF78Lam2x9lcpCYI8BmTIWg4uayJv0HN1VqnqwttfoqKkcpVWKJWc58Pj6fGY4iCBq8f7y-vF8_Hx6E5UAUd8dhOPVexegjapPtQu9Cy498rYX9W5uKjF-Y4kxzavtUhFXl4e1n0CCMSdsN1dXwYg5rCLXMBQwa-V9EcwudLK1KhoossmNI3RSRbb6A3MU-DssoASd2CaDuHfBbBTJoB62q5DHLHvO8gaGzmFvDYjvNgQg2igzoiMMN0io4IVGaFNU_kLoD656R7aNSKQx16ey2JX_Ki6Ud8amwE8oI3ZFuovKYJA6gkplB8YqSjKBiusuRnbyA0SpJ-8hrRjRZJmmAZhmVzRMKwZbe7UHOWLu4Kqt85fSWpTEjblE05z-wmZu5i_wCjNvJgUAAA", 10, "\u5927\u6742\u70e9"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno2ccrzpnVKOkqpSlbRsTpKBUCqWqkEKJMEFEyG84qBvEwgnZuZl5pclJhWYlWSVwJRYVgbC9FeDVGRmJZZnJFclF9cnJRfbpWUX5Qan1RaVAxSnQNWDYQAKT8GBX0AAAA", 10, "\u6454\u70ae"), new PresetConfig("MCXB1:H4sIAAAAAAAA_32PQQrCQAxF75J1NyJu5ioiQ9qmNXScKZnBIsWlO8GlIG68hgcqegunLbqqJaufvJ_8tGBBwft26e7P7np6Pc6QAIFat8BxsMOC_TYT533qGsU2oC05NRQpA2pxTCY5tIFLwT2Hwwiu_oA5ZULoSbPlwGi0r4nyr2eTQD1ECdGZxm72Uz6qYR_buAKLoAoWapxUWlxWURjpZX93miebk-iaUMzILvp7M6_PJo31AeveZ5BLAQAA", 10, "\u968f\u673a\u65c5\u884c"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno6Z8PzjranS1Y-mzH_yc7up3tWKukopSpZRVcrZQKlczPzUpOLEtNKrDLz0jLzMksqgdI5SlaGtbE6SgVgZSVAZUlA0WQ4rxjIQ9VcnpmXEp-ckViUngpRaVKrQ6ZOI-w6acHDdE1KZlEJRImZCSgEkAIqMS2zOCO5KL-4OCm_3KqkKDE5OzMvHRJaxiA3Y1GVlF-UGp9UWlRcAg9VkkwdVU0F1bUAtZL-QAkDAAA", 10, "\u5730\u7206\u5929\u661f"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno2fcGzqT0vF7U9nT__yc7up3tWKukopSpZRVcrZQKlcxPTMoszkovyi4uT8sutMvOSi1ITi1PjczLTUksyc1OBinOUrExrdfArT0nMTUyHKjaujdVRKgDbUALUUgwUBWvNzEtNLkpMK7EqyS9JzY3PT4svzUupzMxLBypIVrIyrI2tBQDiRz6SswAAAA", 10, "\u65e0\u654c\u9886\u57df"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUno-Zf6zjgnPNmxR0lFKVbKKjtVRKgBS1UolQMlioGAmkM7NzEtNLkpMK7EqTyxJLYpPKk3OTi0BSiYrWRnWxtYCAHqEr91LAAAA", 10, "\u751f\u6210\u6c34"), new PresetConfig("MCXB1:H4sIAAAAAAAA_6tWylOyUnrZ3vt0XveLvRueN-1Q0lFKVbKKrlbKBErkJqZlFmckF-UXFyfll1sl5RelxieVFhWXAFXlKFkZ1sbqKBWAVZcAVScBRZPhvGIgD2xGZl5qclFiWolVSV4JRIWhEUgjyJrY2thaAEP3qzuEAAAA", 10, "\u91cd\u578b\u8f70\u70b8"), new PresetConfig("MCXB1:H4sIAAAAAAAA_3WPTQrCQAxG75J1F-12riJSpmOqgTpTJqNFihsX4kY8hCuPIPQ6Ax7D1N8Klqy-5H080oIFBfGwv5138XSM3TV2F0gAQU1aILktyaLxugyKbEmWwkbOFahsO02gfmBBsEK25pNY0m9Ze--aJ5OlfXVg0CXxwnjHXLhGNMajZsx7Gekq5xpx9pYmfzuFW1mDLyYdgazzyMRBf9FRcu71eviqzB1jDLFdKwEAAA", 10, "\u5206\u88c2\u53cd\u5f39\u5f29"));

    private static void registerDynamicPresets(List<PresetCrossbow> presets, Player player) {
        presets.add(PresetCrossbowRegistry.createAlchemyCrossbow(player));
        presets.add(PresetCrossbowRegistry.createBlackHoleCrossbow(player, 1, "\u00a75\u00a7l\u9ed1\u6d1e", 10));
        presets.add(PresetCrossbowRegistry.createBlackHoleCrossbow(player, 3, "\u00a75\u00a7l\u5de8\u578b\u9ed1\u6d1e", 10));
    }

    public static List<PresetCrossbow> getAllPresets(Player player) {
        ArrayList<PresetCrossbow> presets = new ArrayList<PresetCrossbow>();
        for (PresetConfig config : PRESET_CONFIGS) {
            try {
                ItemStack crossbow = CrossbowPresetCodec.decode(config.encoded(), player.level());
                if (crossbow == null || crossbow.isEmpty()) continue;
                presets.add(new PresetCrossbow(null, crossbow, config.weight(), config.comment()));
            }
            catch (Exception e) {
                MafishCrossbow.LOGGER.error("[PresetRegistry] \u89e3\u7801\u9884\u8bbe\u5931\u8d25: {}", (Object)config.comment(), (Object)e);
            }
        }
        PresetCrossbowRegistry.registerDynamicPresets(presets, player);
        return presets;
    }

    private static PresetCrossbow createBlackHoleCrossbow(Player player, int depth, String name, int weight) {
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        crossbow.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        ItemStack structureVoid = new ItemStack((ItemLike)Items.STRUCTURE_VOID, 1);
        crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)structureVoid));
        crossbow.set(ModDataConponents.VOID_DEPTH.get(), (Object)depth);
        HolderLookup lookup = player.level().holderLookup(Registries.ENCHANTMENT);
        lookup.get(Enchantments.INFINITY).ifPresent(holder -> crossbow.enchant((Holder)holder, 1));
        crossbow.set(DataComponents.MAX_DAMAGE, (Object)1);
        crossbow.set(DataComponents.DAMAGE, (Object)0);
        return new PresetCrossbow(null, crossbow, weight, name, true);
    }

    private static PresetCrossbow createAlchemyCrossbow(Player player) {
        ItemStack crossbow = new ItemStack((ItemLike)Items.CROSSBOW);
        crossbow.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"\u00a75\u00a7l\u70bc\u91d1\u672f\u5f29").withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            potions.add(PresetCrossbowRegistry.createRandomPotion(Items.SPLASH_POTION, 1, player));
        }
        crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(potions));
        HolderLookup lookup = player.level().holderLookup(Registries.ENCHANTMENT);
        lookup.get(Enchantments.INFINITY).ifPresent(holder -> crossbow.enchant((Holder)holder, 1));
        lookup.get(Enchantments.MULTISHOT).ifPresent(holder -> crossbow.enchant((Holder)holder, 2));
        crossbow.set(DataComponents.MAX_DAMAGE, (Object)1);
        crossbow.set(DataComponents.DAMAGE, (Object)0);
        return new PresetCrossbow(null, crossbow, 10, "\u70bc\u91d1\u672f\u5f29", true);
    }

    public static ItemStack createCrossbow(PresetCrossbow preset, Player player) {
        return preset.getCrossbow();
    }

    public static ItemStack createRandomPotion(Item potionItem, int count, Player player) {
        ItemStack potion = new ItemStack((ItemLike)potionItem, count);
        ArrayList<Potion> allPotions = new ArrayList<Potion>();
        for (Potion p : BuiltInRegistries.POTION) {
            allPotions.add(p);
        }
        if (!allPotions.isEmpty()) {
            Potion randomPotion = (Potion)allPotions.get(player.getRandom().nextInt(allPotions.size()));
            Holder potionHolder = BuiltInRegistries.POTION.wrapAsHolder((Object)randomPotion);
            potion.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionHolder));
        }
        return potion;
    }

    public static ItemStack createFromEncodedString(String encodedString, Player player) {
        if (!CrossbowPresetCodec.isValidEncoded(encodedString)) {
            MafishCrossbow.LOGGER.error("[PresetRegistry] \u65e0\u6548\u7684\u7f16\u7801\u5b57\u7b26\u4e32");
            return null;
        }
        try {
            return CrossbowPresetCodec.decode(encodedString, player.level());
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("[PresetRegistry] \u89e3\u7801\u9884\u8bbe\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static class PresetCrossbow {
        private final String encodedString;
        private final ItemStack cachedCrossbow;
        private final int weight;
        private final String comment;
        private final boolean isDynamic;

        public PresetCrossbow(String encodedString, ItemStack crossbow, int weight, String comment) {
            this(encodedString, crossbow, weight, comment, false);
        }

        public PresetCrossbow(String encodedString, ItemStack crossbow, int weight, String comment, boolean isDynamic) {
            this.encodedString = encodedString;
            this.cachedCrossbow = crossbow;
            this.weight = weight;
            this.comment = comment;
            this.isDynamic = isDynamic;
        }

        public String getDisplayName() {
            return this.cachedCrossbow.getHoverName().getString();
        }

        public ItemStack getAmmo() {
            ChargedProjectiles charged = (ChargedProjectiles)this.cachedCrossbow.get(DataComponents.CHARGED_PROJECTILES);
            if (charged != null && !charged.isEmpty()) {
                return (ItemStack)charged.getItems().getFirst();
            }
            return ItemStack.EMPTY;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getComment() {
            return this.comment;
        }

        public String getEncodedString() {
            return this.encodedString;
        }

        public ItemStack getCrossbow() {
            return this.cachedCrossbow.copy();
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }
    }

    public record PresetConfig(String encoded, int weight, String comment) {
        public PresetConfig(String encoded, int weight) {
            this(encoded, weight, "");
        }

        public PresetConfig(String encoded) {
            this(encoded, 10, "");
        }
    }
}

