/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.EnchantmentData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.ProjectileData;
import java.util.ArrayList;
import java.util.List;

public record BundleProjectileData(List<ProjectileData> contents, List<EnchantmentData> enchantments) implements ProjectileData
{
    @Override
    public String getType() {
        return "b";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("t", "b");
        JsonArray contentsArray = new JsonArray();
        for (ProjectileData content : this.contents) {
            contentsArray.add((JsonElement)content.toJson());
        }
        json.add("c", (JsonElement)contentsArray);
        JsonArray enchArray = new JsonArray();
        if (this.enchantments != null) {
            for (EnchantmentData ench : this.enchantments) {
                enchArray.add((JsonElement)ench.toJson());
            }
        }
        json.add("e", (JsonElement)enchArray);
        return json;
    }

    public static BundleProjectileData fromJson(JsonObject json) {
        if (!json.has("c")) {
            throw new IllegalArgumentException("Missing 'c' (contents) in BundleProjectileData: " + String.valueOf(json));
        }
        ArrayList<ProjectileData> contents = new ArrayList<ProjectileData>();
        JsonArray contentsArray = json.getAsJsonArray("c");
        for (JsonElement element : contentsArray) {
            contents.add(ProjectileData.fromJson(element.getAsJsonObject()));
        }
        ArrayList<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
        if (json.has("e")) {
            JsonArray enchArray = json.getAsJsonArray("e");
            for (JsonElement element : enchArray) {
                enchantments.add(EnchantmentData.fromJson(element.getAsJsonObject()));
            }
        }
        return new BundleProjectileData(contents, enchantments);
    }
}

