/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.EnchantmentData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.ProjectileData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public record CrossbowPresetData(@Nullable String name, List<EnchantmentData> enchantments, List<ProjectileData> projectiles) {
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.name != null && !this.name.isEmpty()) {
            json.addProperty("n", this.name);
        }
        JsonArray enchArray = new JsonArray();
        for (EnchantmentData ench : this.enchantments) {
            enchArray.add((JsonElement)ench.toJson());
        }
        json.add("e", (JsonElement)enchArray);
        JsonArray projArray = new JsonArray();
        for (ProjectileData proj : this.projectiles) {
            projArray.add((JsonElement)proj.toJson());
        }
        json.add("p", (JsonElement)projArray);
        return json;
    }

    public static CrossbowPresetData fromJson(JsonObject json) {
        String name = null;
        if (json.has("n")) {
            name = json.get("n").getAsString();
        }
        ArrayList<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
        if (json.has("e")) {
            JsonArray enchArray = json.getAsJsonArray("e");
            for (JsonElement element : enchArray) {
                enchantments.add(EnchantmentData.fromJson(element.getAsJsonObject()));
            }
        }
        ArrayList<ProjectileData> projectiles = new ArrayList<ProjectileData>();
        if (json.has("p")) {
            JsonArray projArray = json.getAsJsonArray("p");
            for (JsonElement element : projArray) {
                projectiles.add(ProjectileData.fromJson(element.getAsJsonObject()));
            }
        }
        return new CrossbowPresetData(name, enchantments, projectiles);
    }
}

