/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset.data;

import com.google.gson.JsonObject;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.BundleProjectileData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.CrossbowProjectileData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.SimpleProjectileData;

public sealed interface ProjectileData
permits SimpleProjectileData, BundleProjectileData, CrossbowProjectileData {
    public String getType();

    public JsonObject toJson();

    public static ProjectileData fromJson(JsonObject json) {
        if (!json.has("t")) {
            throw new IllegalArgumentException("Missing type field 't' in projectile JSON: " + String.valueOf(json));
        }
        String type = json.get("t").getAsString();
        try {
            return switch (type) {
                case "s" -> SimpleProjectileData.fromJson(json);
                case "b" -> BundleProjectileData.fromJson(json);
                case "c" -> CrossbowProjectileData.fromJson(json);
                default -> throw new IllegalArgumentException("Unknown projectile type: " + type);
            };
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse projectile of type '" + type + "': " + String.valueOf(json), e);
        }
    }
}

