/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.rougecraft.preset.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.EnchantmentData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.data.ProjectileData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public record SimpleProjectileData(String itemId, int count, List<EnchantmentData> enchantments, @Nullable String potionId) implements ProjectileData
{
    @Override
    public String getType() {
        return "s";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("t", "s");
        json.addProperty("i", this.itemId);
        json.addProperty("c", (Number)this.count);
        if (this.enchantments != null && !this.enchantments.isEmpty()) {
            JsonArray enchArray = new JsonArray();
            for (EnchantmentData ench : this.enchantments) {
                enchArray.add((JsonElement)ench.toJson());
            }
            json.add("e", (JsonElement)enchArray);
        }
        if (this.potionId != null && !this.potionId.isEmpty()) {
            json.addProperty("po", this.potionId);
        }
        return json;
    }

    public static SimpleProjectileData fromJson(JsonObject json) {
        if (!json.has("i")) {
            throw new IllegalArgumentException("Missing 'i' (itemId) in SimpleProjectileData: " + String.valueOf(json));
        }
        if (!json.has("c")) {
            throw new IllegalArgumentException("Missing 'c' (count) in SimpleProjectileData: " + String.valueOf(json));
        }
        String itemId = json.get("i").getAsString();
        int count = json.get("c").getAsInt();
        ArrayList<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
        if (json.has("e")) {
            JsonArray enchArray = json.getAsJsonArray("e");
            for (JsonElement element : enchArray) {
                enchantments.add(EnchantmentData.fromJson(element.getAsJsonObject()));
            }
        }
        String potionId = null;
        if (json.has("po")) {
            potionId = json.get("po").getAsString();
        }
        return new SimpleProjectileData(itemId, count, enchantments, potionId);
    }
}

