/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.towerdefense.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;

public class MobRewardConfig {
    private static final Map<EntityType<?>, Integer> REWARD_MAP = new HashMap();
    private static final int DEFAULT_REWARD = 1;

    public static int getReward(LivingEntity entity) {
        if (!MobRewardConfig.isHostileMob(entity)) {
            return 0;
        }
        return REWARD_MAP.getOrDefault(entity.getType(), 1);
    }

    private static boolean isHostileMob(LivingEntity entity) {
        return entity instanceof Monster || entity instanceof Enemy || entity instanceof EnderDragon || entity instanceof Slime;
    }

    public static void setReward(EntityType<?> entityType, int reward) {
        REWARD_MAP.put(entityType, reward);
    }

    public static int getDefaultReward() {
        return 1;
    }

    public static boolean hasReward(EntityType<?> entityType) {
        return REWARD_MAP.containsKey(entityType);
    }

    public static Map<EntityType<?>, Integer> getAllRewards() {
        return new HashMap(REWARD_MAP);
    }

    static {
        REWARD_MAP.put(EntityType.ZOMBIE, 2);
        REWARD_MAP.put(EntityType.ZOMBIE_VILLAGER, 2);
        REWARD_MAP.put(EntityType.HUSK, 2);
        REWARD_MAP.put(EntityType.DROWNED, 3);
        REWARD_MAP.put(EntityType.SKELETON, 3);
        REWARD_MAP.put(EntityType.STRAY, 3);
        REWARD_MAP.put(EntityType.SPIDER, 2);
        REWARD_MAP.put(EntityType.CAVE_SPIDER, 3);
        REWARD_MAP.put(EntityType.CREEPER, 5);
        REWARD_MAP.put(EntityType.WITCH, 6);
        REWARD_MAP.put(EntityType.BLAZE, 7);
        REWARD_MAP.put(EntityType.GHAST, 8);
        REWARD_MAP.put(EntityType.ENDERMAN, 10);
        REWARD_MAP.put(EntityType.PIGLIN_BRUTE, 12);
        REWARD_MAP.put(EntityType.WARDEN, 15);
        REWARD_MAP.put(EntityType.RAVAGER, 15);
        REWARD_MAP.put(EntityType.WITHER, 50);
        REWARD_MAP.put(EntityType.ENDER_DRAGON, 100);
        REWARD_MAP.put(EntityType.SLIME, 1);
        REWARD_MAP.put(EntityType.MAGMA_CUBE, 2);
        REWARD_MAP.put(EntityType.SILVERFISH, 1);
        REWARD_MAP.put(EntityType.ENDERMITE, 1);
        REWARD_MAP.put(EntityType.PHANTOM, 4);
        REWARD_MAP.put(EntityType.VEX, 3);
        REWARD_MAP.put(EntityType.PILLAGER, 4);
        REWARD_MAP.put(EntityType.VINDICATOR, 5);
        REWARD_MAP.put(EntityType.EVOKER, 8);
        REWARD_MAP.put(EntityType.SHULKER, 6);
        REWARD_MAP.put(EntityType.HOGLIN, 7);
        REWARD_MAP.put(EntityType.ZOGLIN, 7);
        REWARD_MAP.put(EntityType.PIGLIN, 3);
        REWARD_MAP.put(EntityType.ZOMBIFIED_PIGLIN, 3);
        REWARD_MAP.put(EntityType.GUARDIAN, 6);
        REWARD_MAP.put(EntityType.ELDER_GUARDIAN, 20);
    }
}

