/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.towerdefense.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class TowerDefensePlayerData {
    private int emeralds;
    private int enchantmentPoints;
    private int currentWave;
    public static final Codec<TowerDefensePlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("emeralds").forGetter(TowerDefensePlayerData::getEmeralds), (App)Codec.INT.fieldOf("enchantment_points").forGetter(TowerDefensePlayerData::getEnchantmentPoints), (App)Codec.INT.fieldOf("current_wave").forGetter(TowerDefensePlayerData::getCurrentWave)).apply((Applicative)instance, TowerDefensePlayerData::new));
    public static final StreamCodec<ByteBuf, TowerDefensePlayerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, TowerDefensePlayerData::getEmeralds, (StreamCodec)ByteBufCodecs.VAR_INT, TowerDefensePlayerData::getEnchantmentPoints, (StreamCodec)ByteBufCodecs.VAR_INT, TowerDefensePlayerData::getCurrentWave, TowerDefensePlayerData::new);

    public TowerDefensePlayerData() {
        this(0, 0, 0);
    }

    public TowerDefensePlayerData(int emeralds, int enchantmentPoints, int currentWave) {
        this.emeralds = emeralds;
        this.enchantmentPoints = enchantmentPoints;
        this.currentWave = currentWave;
    }

    public int getEmeralds() {
        return this.emeralds;
    }

    public int getEnchantmentPoints() {
        return this.enchantmentPoints;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public void setEmeralds(int emeralds) {
        this.emeralds = Math.max(0, emeralds);
    }

    public void setEnchantmentPoints(int enchantmentPoints) {
        this.enchantmentPoints = Math.max(0, enchantmentPoints);
    }

    public void setCurrentWave(int currentWave) {
        this.currentWave = Math.max(0, currentWave);
    }

    public void addEmeralds(int amount) {
        this.emeralds = Math.max(0, this.emeralds + amount);
    }

    public void addEnchantmentPoints(int amount) {
        this.enchantmentPoints = Math.max(0, this.enchantmentPoints + amount);
    }

    public boolean hasEnoughEmeralds(int amount) {
        return this.emeralds >= amount;
    }

    public void reset() {
        this.emeralds = 0;
        this.enchantmentPoints = 0;
        this.currentWave = 0;
    }

    public String toString() {
        return "TowerDefensePlayerData{emeralds=" + this.emeralds + ", enchantmentPoints=" + this.enchantmentPoints + ", currentWave=" + this.currentWave + "}";
    }
}

