/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.towerdefense.event;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.towerdefense.config.MobRewardConfig;
import com.mafuyu33.mafishcrossbow.towerdefense.config.TowerDefenseConfig;
import com.mafuyu33.mafishcrossbow.towerdefense.economy.TowerDefenseEconomy;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="mafishcrossbow")
public class MobKillRewardHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!TowerDefenseConfig.isEnabled()) {
            return;
        }
        LivingEntity deadEntity = event.getEntity();
        if (deadEntity.level().isClientSide) {
            return;
        }
        DamageSource source = event.getSource();
        Player killer = MobKillRewardHandler.getKillerPlayer(source);
        if (killer == null) {
            return;
        }
        int reward = MobRewardConfig.getReward(deadEntity);
        if (reward <= 0) {
            return;
        }
        TowerDefenseEconomy.addEmeralds(killer, reward);
        MafishCrossbow.LOGGER.debug("Player {} killed {} and earned {} emeralds", new Object[]{killer.getName().getString(), deadEntity.getType().getDescriptionId(), reward});
        MobKillRewardHandler.sendRewardMessage(killer, deadEntity, reward);
    }

    private static Player getKillerPlayer(DamageSource source) {
        Projectile projectile;
        Entity owner;
        Entity directEntity = source.getDirectEntity();
        Entity causingEntity = source.getEntity();
        if (causingEntity instanceof Player) {
            Player player = (Player)causingEntity;
            return player;
        }
        if (directEntity instanceof Projectile && (owner = (projectile = (Projectile)directEntity).getOwner()) instanceof Player) {
            Player player = (Player)owner;
            return player;
        }
        if (directEntity instanceof Player) {
            Player player = (Player)directEntity;
            return player;
        }
        if (directEntity != null && directEntity.getPersistentData().contains("mafishcrossbow:owner_most")) {
            Optional mostOpt = directEntity.getPersistentData().getLong("mafishcrossbow:owner_most");
            Optional leastOpt = directEntity.getPersistentData().getLong("mafishcrossbow:owner_least");
            if (mostOpt.isPresent() && leastOpt.isPresent()) {
                ServerLevel serverLevel;
                Entity ownerEntity;
                UUID ownerUUID = new UUID((Long)mostOpt.get(), (Long)leastOpt.get());
                Level level = directEntity.level();
                if (level instanceof ServerLevel && (ownerEntity = (serverLevel = (ServerLevel)level).getEntity(ownerUUID)) instanceof Player) {
                    Player player = (Player)ownerEntity;
                    return player;
                }
            }
        }
        return null;
    }

    private static void sendRewardMessage(Player player, LivingEntity deadEntity, int reward) {
        MutableComponent message = Component.literal((String)"").append((Component)Component.literal((String)"+").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)String.valueOf(reward)).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.WHITE)).append((Component)Component.translatable((String)"item.minecraft.emerald").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.GRAY)).append((Component)deadEntity.getDisplayName().copy().withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.GRAY));
        player.displayClientMessage((Component)message, true);
    }

    private static boolean isKilledByTurret(DamageSource source) {
        Entity directEntity = source.getDirectEntity();
        if (directEntity instanceof Projectile) {
            Projectile projectile = (Projectile)directEntity;
            Entity owner = projectile.getOwner();
            return owner instanceof Player;
        }
        return false;
    }
}

