/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class ShulkerBoxHelper {
    public static boolean isShulkerBox(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        return !stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock;
    }

    public static List<ItemStack> getAllItemsFromShulkerBox(ItemStack shulkerBox) {
        if (!ShulkerBoxHelper.isShulkerBox(shulkerBox)) {
            return new ArrayList<ItemStack>();
        }
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents == null) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        contents.stream().forEach(items::add);
        return items;
    }

    public static List<ItemStack> getProjectileItemsFromShulkerBox(ItemStack shulkerBox) {
        return ShulkerBoxHelper.getAllItemsFromShulkerBox(shulkerBox).stream().filter(item -> !item.isEmpty() && item.getItem() != Items.ENCHANTED_BOOK).collect(Collectors.toList());
    }

    public static List<ItemStack> getEnchantedBooksFromShulkerBox(ItemStack shulkerBox) {
        return ShulkerBoxHelper.getAllItemsFromShulkerBox(shulkerBox).stream().filter(item -> !item.isEmpty() && item.getItem() == Items.ENCHANTED_BOOK).collect(Collectors.toList());
    }

    public static boolean hasProjectileItems(ItemStack shulkerBox) {
        return !ShulkerBoxHelper.getProjectileItemsFromShulkerBox(shulkerBox).isEmpty();
    }

    public static void removeItemFromShulkerBox(ItemStack shulkerBox, ItemStack itemToRemove) {
        if (!ShulkerBoxHelper.isShulkerBox(shulkerBox)) {
            return;
        }
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents == null) {
            return;
        }
        ArrayList allItems = new ArrayList();
        contents.stream().forEach(allItems::add);
        ArrayList<ItemStack> newContents = new ArrayList<ItemStack>();
        boolean removed = false;
        for (ItemStack contentItem : allItems) {
            if (contentItem.isEmpty()) continue;
            if (!removed && ItemStack.isSameItemSameComponents((ItemStack)contentItem, (ItemStack)itemToRemove)) {
                contentItem = contentItem.copy();
                contentItem.shrink(1);
                removed = true;
            }
            if (contentItem.isEmpty()) continue;
            newContents.add(contentItem);
        }
        shulkerBox.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(newContents));
    }

    public static ItemStack getItemAtIndex(ItemStack shulkerBox, int index) {
        List<ItemStack> items = ShulkerBoxHelper.getProjectileItemsFromShulkerBox(shulkerBox);
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int safeIndex = index % items.size();
        return items.get(safeIndex);
    }

    public static int getNextValidIndex(ItemStack shulkerBox, int currentIndex) {
        List<ItemStack> items = ShulkerBoxHelper.getProjectileItemsFromShulkerBox(shulkerBox);
        if (items.isEmpty()) {
            return 0;
        }
        return (currentIndex + 1) % items.size();
    }
}

