/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class StructureBlockHelper {
    @Nullable
    public static BlockState findOtherHalf(Level level, BlockPos pos, BlockState state) {
        Half half;
        BlockPos otherPos;
        BlockState other;
        Block block = state.getBlock();
        if (block instanceof DoorBlock && state.hasProperty((Property)BlockStateProperties.HALF) && (other = level.getBlockState(otherPos = (half = (Half)state.getValue((Property)BlockStateProperties.HALF)) == Half.BOTTOM ? pos.above() : pos.below())).getBlock() == block && other.hasProperty((Property)BlockStateProperties.HALF) && other.getValue((Property)BlockStateProperties.HALF) != half) {
            return other;
        }
        if (state.hasProperty((Property)BlockStateProperties.BED_PART) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            BedPart part = (BedPart)state.getValue((Property)BlockStateProperties.BED_PART);
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockPos otherPos2 = part == BedPart.FOOT ? pos.relative(facing) : pos.relative(facing.getOpposite());
            BlockState other2 = level.getBlockState(otherPos2);
            if (other2.getBlock() == block && other2.hasProperty((Property)BlockStateProperties.BED_PART) && other2.getValue((Property)BlockStateProperties.BED_PART) != part) {
                return other2;
            }
        }
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && (other = level.getBlockState(otherPos = (half = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).getBlock() == block && other.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && other.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) != half) {
            return other;
        }
        return null;
    }

    public static BlockPos getRenderOffset(BlockState main, BlockState other) {
        Half otherHalf;
        Half mainHalf;
        if (main.getBlock() != other.getBlock()) {
            return BlockPos.ZERO;
        }
        if (main.getBlock() instanceof DoorBlock && main.hasProperty((Property)BlockStateProperties.HALF) && other.hasProperty((Property)BlockStateProperties.HALF) && (mainHalf = (Half)main.getValue((Property)BlockStateProperties.HALF)) != (otherHalf = (Half)other.getValue((Property)BlockStateProperties.HALF))) {
            return otherHalf == Half.TOP ? new BlockPos(0, 1, 0) : new BlockPos(0, -1, 0);
        }
        if (main.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && other.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && (mainHalf = (DoubleBlockHalf)main.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) != (otherHalf = (DoubleBlockHalf)other.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF))) {
            return otherHalf == DoubleBlockHalf.UPPER ? new BlockPos(0, 1, 0) : new BlockPos(0, -1, 0);
        }
        if (main.hasProperty((Property)BlockStateProperties.BED_PART) && other.hasProperty((Property)BlockStateProperties.BED_PART) && main.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            BedPart mainPart = (BedPart)main.getValue((Property)BlockStateProperties.BED_PART);
            BedPart otherPart = (BedPart)other.getValue((Property)BlockStateProperties.BED_PART);
            Direction facing = (Direction)main.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (mainPart != otherPart) {
                Direction dir = otherPart == BedPart.HEAD ? facing : facing.getOpposite();
                return new BlockPos(dir.getStepX(), dir.getStepY(), dir.getStepZ());
            }
        }
        return BlockPos.ZERO;
    }
}

