/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.client;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.skill_tree_rpgs.client.effect.DeflectionEffectRenderer;
import net.skill_tree_rpgs.client.effect.HolyChargeEffectRenderer;
import net.skill_tree_rpgs.effect.SkillEffects;
import net.skill_tree_rpgs.skills.SkillDefinitions;
import net.skill_tree_rpgs.skills.Spells;
import net.skill_tree_rpgs.utils.TranslationUtil;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.render.BuffParticleSpawner;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;

public class SkillTreeClientMod {
    public static void init() {
        for (Spells.Entry spell : Spells.all) {
            if (spell.mutator() == null) continue;
            SpellTooltip.addDescriptionMutator((ResourceLocation)spell.id(), (SpellTooltip.DescriptionMutator)spell.mutator());
        }
        for (SkillDefinitions.Entry entry : SkillDefinitions.ENTRIES) {
            String skillId = entry.id();
            if (entry.spellReward() != null) {
                SpellContainer container = entry.spellReward().get(0);
                ResourceLocation id = ResourceLocation.parse((String)((String)container.spell_ids().getFirst()));
                TranslationUtil.resolvers.put(skillId, () -> TranslationUtil.resolveSpellDetails(id));
                continue;
            }
            if (entry.attributeReward() == null) continue;
            SkillDefinitions.EntityAttributeReward attribute = entry.attributeReward();
            TranslationUtil.resolvers.put(skillId, () -> TranslationUtil.resolveAttributeModifierTooltip(attribute));
        }
        SkillTreeClientMod.registerCustomModels();
        SkillTreeClientMod.registerEffectRenderers();
    }

    private static void registerCustomModels() {
        CustomModels.registerModelIds(List.of(HolyChargeEffectRenderer.modelId, DeflectionEffectRenderer.modelId));
    }

    private static void registerEffectRenderers() {
        ParticleBatch magicSnareParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 2.0f, 0.15f, 0.15f).preSpawnTravel(5.0f).invert();
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.ARCANE_SLOWNESS.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{magicSnareParticles.copy().color(Spells.ARCANE_COLOR)}));
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.HAMSTRING.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{magicSnareParticles.copy().color(Color.RAGE.toRGBA())}));
        ParticleBatch fireVulnerability = new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, 0.1f, 0.1f, 0.15f);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.FIRE_VULNERABILITY.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{fireVulnerability}));
        ParticleBatch frostVulnerability = new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.CENTER, 0.1f, 0.1f, 0.15f);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.FROST_VULNERABILITY.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{frostVulnerability}));
        ParticleBatch healingFocus = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 0.2f, 0.15f, 0.35f).color(Spells.HOLY_COLOR);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.HEALING_FOCUS.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{healingFocus}));
        ParticleBatch incanterParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 0.4f, 0.15f, 0.15f).preSpawnTravel(2.0f).color(Spells.HOLY_COLOR);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.INCANTER_CADENCE.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{incanterParticles}));
        ParticleBatch ruptureParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 2.0f, 0.45f, 0.75f).color(Color.BLOOD.toRGBA());
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.FRACTURE.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{ruptureParticles}));
        ParticleBatch rhythmParticles = new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.05f).color(Color.NATURE.toRGBA()).scale(0.75f).followEntity(true);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.RHYTHM.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{rhythmParticles}).scaleWithAmplifier(false).withFrequency(40).invertFrequency());
        ParticleBatch speedParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 0.3f, 0.05f, 0.15f).extent(-0.2f);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.PURSUIT_OF_JUSTICE.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{speedParticles.copy().color(Spells.HOLY_COLOR)}));
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.ARCANE_SPEED.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{speedParticles.copy().color(Spells.ARCANE_COLOR)}));
        ParticleBatch blizzardSlowParticles = new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.FEET, 1.0f, 0.15f, 0.15f);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.BLIZZARD_SLOW.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{blizzardSlowParticles}));
        ParticleBatch arcaneBarrierParticles = new ParticleBatch(SpellEngineParticles.aura_effect_622.id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(1.4f).followEntity(true);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.ARCANE_WARD.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(arcaneBarrierParticles.copy().color(Color.ARCANE.alpha(0.5f).toRGBA())).withFrequency(30).scaleWithAmplifier(false));
        ParticleBatch fireBarrierParticles = new ParticleBatch(SpellEngineParticles.aura_effect_716.id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(1.4f).followEntity(true);
        Color fireColor = Color.from((int)0xFF9933);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.FIRE_WARD.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(fireBarrierParticles.copy().color(fireColor.alpha(0.5f).toRGBA())).withFrequency(30).scaleWithAmplifier(false));
        ParticleBatch frostBarrierParticles = new ParticleBatch(SpellEngineParticles.aura_effect_691.id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(1.4f).followEntity(true);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.FROST_WARD.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(frostBarrierParticles.copy().color(Color.FROST.alpha(0.5f).toRGBA())).withFrequency(30).scaleWithAmplifier(false));
        ParticleBatch phaseShiftParticles = new ParticleBatch(SpellEngineParticles.aura_effect_668.id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(1.4f).followEntity(true);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.PHASE_SHIFT.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(phaseShiftParticles.color(Color.ARCANE.toRGBA())).withFrequency(20).scaleWithAmplifier(false));
        ParticleBatch blazingSpeedParticles = new ParticleBatch(SpellEngineParticles.flame_ground.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.0f, 0.0f);
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.BLAZING_SPEED.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{blazingSpeedParticles}));
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.PAIN_SUPPRESSION.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(SpellBuilder.Particles.aura((ResourceLocation)SpellEngineParticles.aura_effect_619.id()).scale(1.5f).color(Color.HOLY.blend(Color.WHITE, 0.5f).alpha(0.5f).toRGBA())).withFrequency(30).scaleWithAmplifier(false));
        CustomModelStatusEffect.register((MobEffect)SkillEffects.CELESTIAL_ORB.effect, (CustomModelStatusEffect.Renderer)new HolyChargeEffectRenderer());
        ParticleBatch sealOfCrusaderParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 1.0f, 0.05f, 0.1f).color(Color.HOLY.toRGBA());
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.SEAL_OF_CRUSADER.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{sealOfCrusaderParticles}));
        ParticleBatch enrageParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SKULL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 1.0f, 0.15f, 0.15f).color(Color.RAGE.toRGBA());
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.ENRAGE.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{enrageParticles}));
        ParticleBatch cheatDeathParticles = new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SKULL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 0.5f, 0.0f, 0.0f).color(Spells.ROGUE_SHADOW_COLOR.toRGBA());
        CustomParticleStatusEffect.register((MobEffect)SkillEffects.CHEAT_DEATH.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch[]{cheatDeathParticles}));
        CustomModelStatusEffect.register((MobEffect)SkillEffects.DEFLECTION.effect, (CustomModelStatusEffect.Renderer)new DeflectionEffectRenderer());
    }
}

