/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.data_gen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2447;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.puffish.skillsmod.reward.builtin.AttributeReward;
import net.skill_tree_rpgs.data_gen.SkillDefinitionGenerator;
import net.skill_tree_rpgs.effect.SkillEffects;
import net.skill_tree_rpgs.items.SkillItems;
import net.skill_tree_rpgs.node.SpellContainerReward;
import net.skill_tree_rpgs.skills.SkillDefinitions;
import net.skill_tree_rpgs.skills.SkillTreeSounds;
import net.skill_tree_rpgs.skills.Spells;
import net.skill_tree_rpgs.utils.ResolvableTextContent;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.client.gui.SpellTooltip;

public class SkillTreeModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LangGenerator::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(SpellsGen::new);
        pack.addProvider(SkillDefinitionGen::new);
    }

    public static class SpellsGen
    extends SpellGenerator {
        public SpellsGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (Spells.Entry entry : Spells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class SkillDefinitionGen
    extends SkillDefinitionGenerator {
        public SkillDefinitionGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generate(SkillDefinitionGenerator.Builder builder) {
            LinkedHashMap<String, SkillDefinitionGenerator.Format> skillDefinitions = new LinkedHashMap<String, SkillDefinitionGenerator.Format>();
            for (SkillDefinitions.Entry skill : SkillDefinitions.ENTRIES) {
                SkillDefinitionGenerator.Translatable title = null;
                if (skill.title() != null && !skill.title().isEmpty()) {
                    title = new SkillDefinitionGenerator.Translatable(skill.titleTranslationKey());
                }
                class_5250 description = skill.description() != null && !skill.description().isEmpty() ? class_2561.method_43471((String)skill.descriptionTranslationKey()) : class_5250.method_43477((class_7417)new ResolvableTextContent(skill.id()));
                SkillDefinitionGenerator.Icon icon = null;
                switch (skill.icon().type()) {
                    case TEXTURE: {
                        icon = SkillDefinitionGenerator.Icon.texture(skill.icon().value());
                        break;
                    }
                    case ITEM: {
                        icon = SkillDefinitionGenerator.Icon.item(skill.icon().value());
                        break;
                    }
                    case EFFECT: {
                        icon = SkillDefinitionGenerator.Icon.effect(skill.icon().value());
                    }
                }
                ArrayList<SkillDefinitionGenerator.Reward> rewards = new ArrayList<SkillDefinitionGenerator.Reward>();
                if (skill.attributeReward() != null) {
                    SkillDefinitions.EntityAttributeReward attribute = skill.attributeReward();
                    rewards.add(new SkillDefinitionGenerator.Reward(AttributeReward.ID.toString(), SkillDefinitionGenerator.RewardAttribute.from(attribute.attribute(), attribute.modifier())));
                }
                if (skill.spellReward() != null) {
                    rewards.add(new SkillDefinitionGenerator.Reward(SpellContainerReward.ID.toString(), new SpellContainerReward.DataStructure(skill.spellReward())));
                }
                SkillDefinitionGenerator.Format format = new SkillDefinitionGenerator.Format(title, (class_2561)description, icon, rewards, skill.required_mods());
                skillDefinitions.put(skill.id(), format);
            }
            builder.entries.add(new SkillDefinitionGenerator.Entry(SkillDefinitions.CATEGORY_ID, skillDefinitions));
        }
    }

    public static class RecipeProvider
    extends FabricRecipeProvider {
        public RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 recipeExporter) {
            class_2447.method_10437((class_7800)class_7800.field_40639, (class_1935)SkillItems.ORB_OF_OBLIVION.item()).method_10439(" X ").method_10439("XCX").method_10439(" X ").method_10434(Character.valueOf('X'), (class_1935)class_1802.field_8287).method_10434(Character.valueOf('C'), (class_1935)class_1802.field_8477).method_10429(FabricRecipeProvider.method_32807((class_1935)class_1802.field_8287), FabricRecipeProvider.method_10426((class_1935)class_1802.field_8287)).method_10431(recipeExporter);
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            SkillItems.ENTRIES.forEach(entry -> itemModelGenerator.method_25733(entry.item(), class_4943.field_22938));
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("skill_tree_rpgs", SkillTreeSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().method_12832(), (int)entry.variants())).toList()));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            for (SkillItems.Entry item : SkillItems.ENTRIES) {
                translationBuilder.add(item.item(), item.title());
                for (SkillItems.LoreLine.Translatable lore : item.loreTranslation()) {
                    translationBuilder.add(lore.translationKey(), lore.line().text());
                }
            }
            for (SkillDefinitions.Entry skill : SkillDefinitions.ENTRIES) {
                if (skill.title() != null && !skill.title().isEmpty()) {
                    translationBuilder.add(skill.titleTranslationKey(), skill.title());
                }
                if (skill.description() == null || skill.description().isEmpty()) continue;
                translationBuilder.add(skill.descriptionTranslationKey(), skill.description());
            }
            for (Spells.Entry entry2 : Spells.all) {
                translationBuilder.add(SpellTooltip.spellTranslationKey((class_2960)entry2.id()), entry2.title());
                translationBuilder.add(SpellTooltip.spellDescriptionTranslationKey((class_2960)entry2.id()), entry2.description());
            }
            SkillEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.method_5567(), entry.title);
                translationBuilder.add(entry.effect.method_5567() + ".description", entry.description);
            });
        }
    }
}

