/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.data_gen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.puffish.skillsmod.reward.builtin.AttributeReward;
import net.skill_tree_rpgs.data_gen.SkillDefinitionGenerator;
import net.skill_tree_rpgs.effect.SkillEffects;
import net.skill_tree_rpgs.items.SkillItems;
import net.skill_tree_rpgs.node.SpellContainerReward;
import net.skill_tree_rpgs.skills.SkillDefinitions;
import net.skill_tree_rpgs.skills.SkillTreeSounds;
import net.skill_tree_rpgs.skills.Spells;
import net.skill_tree_rpgs.utils.ResolvableTextContent;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.client.gui.SpellTooltip;

public class SkillTreeModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LangGenerator::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(SpellsGen::new);
        pack.addProvider(SkillDefinitionGen::new);
    }

    public static class SpellsGen
    extends SpellGenerator {
        public SpellsGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (Spells.Entry entry : Spells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class SkillDefinitionGen
    extends SkillDefinitionGenerator {
        public SkillDefinitionGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generate(SkillDefinitionGenerator.Builder builder) {
            LinkedHashMap<String, SkillDefinitionGenerator.Format> skillDefinitions = new LinkedHashMap<String, SkillDefinitionGenerator.Format>();
            for (SkillDefinitions.Entry skill : SkillDefinitions.ENTRIES) {
                SkillDefinitionGenerator.Translatable title = null;
                if (skill.title() != null && !skill.title().isEmpty()) {
                    title = new SkillDefinitionGenerator.Translatable(skill.titleTranslationKey());
                }
                MutableComponent description = skill.description() != null && !skill.description().isEmpty() ? Component.translatable((String)skill.descriptionTranslationKey()) : MutableComponent.create((ComponentContents)new ResolvableTextContent(skill.id()));
                SkillDefinitionGenerator.Icon icon = null;
                switch (skill.icon().type()) {
                    case TEXTURE: {
                        icon = SkillDefinitionGenerator.Icon.texture(skill.icon().value());
                        break;
                    }
                    case ITEM: {
                        icon = SkillDefinitionGenerator.Icon.item(skill.icon().value());
                        break;
                    }
                    case EFFECT: {
                        icon = SkillDefinitionGenerator.Icon.effect(skill.icon().value());
                    }
                }
                ArrayList<SkillDefinitionGenerator.Reward> rewards = new ArrayList<SkillDefinitionGenerator.Reward>();
                if (skill.attributeReward() != null) {
                    SkillDefinitions.EntityAttributeReward attribute = skill.attributeReward();
                    rewards.add(new SkillDefinitionGenerator.Reward(AttributeReward.ID.toString(), SkillDefinitionGenerator.RewardAttribute.from(attribute.attribute(), attribute.modifier())));
                }
                if (skill.spellReward() != null) {
                    rewards.add(new SkillDefinitionGenerator.Reward(SpellContainerReward.ID.toString(), new SpellContainerReward.DataStructure(skill.spellReward())));
                }
                SkillDefinitionGenerator.Format format = new SkillDefinitionGenerator.Format(title, (Component)description, icon, rewards);
                skillDefinitions.put(skill.id(), format);
            }
            builder.entries.add(new SkillDefinitionGenerator.Entry(SkillDefinitions.CATEGORY_ID, skillDefinitions));
        }
    }

    public static class RecipeProvider
    extends FabricRecipeProvider {
        public RecipeProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput recipeExporter) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)SkillItems.ORB_OF_OBLIVION.item()).pattern(" X ").pattern("XCX").pattern(" X ").define(Character.valueOf('X'), (ItemLike)Items.EXPERIENCE_BOTTLE).define(Character.valueOf('C'), (ItemLike)Items.DIAMOND).unlockedBy(FabricRecipeProvider.getHasName((ItemLike)Items.EXPERIENCE_BOTTLE), FabricRecipeProvider.has((ItemLike)Items.EXPERIENCE_BOTTLE)).save(recipeExporter);
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            SkillItems.ENTRIES.forEach(entry -> itemModelGenerator.generateFlatItem(entry.item(), ModelTemplates.FLAT_ITEM));
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("skill_tree_rpgs", SkillTreeSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().getPath(), (int)entry.variants())).toList()));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            for (SkillItems.Entry item : SkillItems.ENTRIES) {
                translationBuilder.add(item.item(), item.title());
                for (SkillItems.LoreLine.Translatable lore : item.loreTranslation()) {
                    translationBuilder.add(lore.translationKey(), lore.line().text());
                }
            }
            for (SkillDefinitions.Entry skill : SkillDefinitions.ENTRIES) {
                if (skill.title() != null && !skill.title().isEmpty()) {
                    translationBuilder.add(skill.titleTranslationKey(), skill.title());
                }
                if (skill.description() == null || skill.description().isEmpty()) continue;
                translationBuilder.add(skill.descriptionTranslationKey(), skill.description());
            }
            for (Spells.Entry entry2 : Spells.all) {
                translationBuilder.add(SpellTooltip.spellTranslationKey((ResourceLocation)entry2.id()), entry2.title());
                translationBuilder.add(SpellTooltip.spellDescriptionTranslationKey((ResourceLocation)entry2.id()), entry2.description());
            }
            SkillEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.getDescriptionId(), entry.title);
                translationBuilder.add(entry.effect.getDescriptionId() + ".description", entry.description);
            });
        }
    }
}

