/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.skill_tree_rpgs.items.RespecItem;

public class SkillItems {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final Entry ORB_OF_OBLIVION = SkillItems.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"skill_tree_rpgs", (String)"orb_of_oblivion"), "Orb of Oblivion", List.of(new LoreLine("Reset all skill points spend on the Class Skill Tree.", ChatFormatting.GRAY)), RespecItem::new, new Item.Properties().rarity(Rarity.UNCOMMON).durability(1)));

    private static Entry add(Entry entry) {
        ENTRIES.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : ENTRIES) {
            Item item;
            List<Component> lore = entry.loreTranslation().stream().map(line -> Component.translatable((String)line.translationKey()).withStyle(line.line().formatting())).toList();
            entry.container.item = item = entry.factory().apply(entry.settings().component(DataComponents.LORE, (Object)new ItemLore(List.of(), lore)));
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.COMBAT).register(content -> {
            for (Entry entry : ENTRIES) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Entry(ResourceLocation id, String title, List<LoreLine> lore, Function<Item.Properties, Item> factory, Item.Properties settings, Container container) {
        public Entry(ResourceLocation id, String title, List<LoreLine> lore, Item.Properties settings) {
            this(id, title, lore, Item::new, settings);
        }

        public Entry(ResourceLocation id, String title, List<LoreLine> lore, Function<Item.Properties, Item> factory, Item.Properties settings) {
            this(id, title, lore, factory, settings, new Container());
        }

        public Item item() {
            return this.container.item;
        }

        public List<LoreLine.Translatable> loreTranslation() {
            ArrayList<LoreLine.Translatable> keys = new ArrayList<LoreLine.Translatable>();
            int index = 0;
            for (LoreLine line : this.lore) {
                String key = "item." + this.id.getNamespace() + "." + this.id.getPath() + ".lore." + index++;
                keys.add(new LoreLine.Translatable(key, line));
            }
            return keys;
        }
    }

    public static class Container {
        Item item;
    }

    public record LoreLine(String text, ChatFormatting formatting) {

        public record Translatable(String translationKey, LoreLine line) {
        }
    }
}

