/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.AuroraLogger;
import gg.auroramc.aurora.api.item.ItemManager;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.collections.api.AuroraCollectionsProvider;
import gg.auroramc.collections.api.data.CollectionData;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.command.CommandManager;
import gg.auroramc.collections.config.CollectionConfig;
import gg.auroramc.collections.config.ConfigManager;
import gg.auroramc.collections.hooks.HookManager;
import gg.auroramc.collections.libs.bstats.bukkit.Metrics;
import gg.auroramc.collections.placeholder.CollectionsPlaceholderHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AuroraCollections
extends JavaPlugin {
    private ConfigManager configManager;
    private CommandManager commandManager;
    private CollectionManager collectionManager;
    private ItemManager itemManager;
    private static AuroraLogger l;

    public static AuroraLogger logger() {
        return l;
    }

    public void onLoad() {
        this.configManager = new ConfigManager(this);
        l = AuroraAPI.createLogger((String)"AuroraCollections", () -> this.configManager.getConfig().getDebug());
        this.configManager.reload();
        HookManager.loadHooks(this);
        for (Map.Entry<String, Map<String, CollectionConfig>> entry : this.configManager.getCollections().entrySet()) {
            AuroraAPI.getLeaderboards().registerBoard("cc_" + entry.getKey(), user -> this.collectionManager.getCollectionsByCategory((String)entry.getKey()).stream().mapToDouble(collection -> ((CollectionData)user.getData(CollectionData.class)).getCollectionCount(collection.getCategory(), collection.getId()).longValue()).sum(), lb -> AuroraAPI.formatNumberShort((double)Double.valueOf(lb.getValue()).longValue()), this.configManager.getConfig().getLeaderboard().getCacheSize().intValue(), this.configManager.getConfig().getLeaderboard().getMinItemsCollected().doubleValue());
            for (String id : entry.getValue().keySet()) {
                AuroraAPI.getLeaderboards().registerBoard(entry.getKey() + "_" + id, user -> (double)((CollectionData)user.getData(CollectionData.class)).getCollectionCount((String)entry.getKey(), id), lb -> AuroraAPI.formatNumber((long)Double.valueOf(lb.getValue()).longValue()), this.configManager.getConfig().getLeaderboard().getCacheSize().intValue(), this.configManager.getConfig().getLeaderboard().getMinItemsCollected().doubleValue());
            }
        }
    }

    public void onEnable() {
        this.itemManager = AuroraAPI.getItemManager();
        AuroraAPI.getUserManager().registerUserDataHolder(CollectionData.class);
        AuroraAPI.registerPlaceholderHandler((PlaceholderHandler)new CollectionsPlaceholderHandler(this));
        this.commandManager = new CommandManager(this);
        this.commandManager.reload();
        this.collectionManager = new CollectionManager(this);
        HookManager.enableHooks(this);
        Bukkit.getGlobalRegionScheduler().run((Plugin)this, task -> this.collectionManager.reloadCollections());
        try {
            Field field = AuroraCollectionsProvider.class.getDeclaredField("plugin");
            field.setAccessible(true);
            field.set(null, (Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            l.severe("Failed to initialize api provider! error: " + e.getMessage());
        }
        new Metrics(this, 23778);
    }

    public void reload() {
        this.configManager.reload();
        this.commandManager.reload();
        this.collectionManager.reloadCollections();
        CompletableFuture.runAsync(() -> Bukkit.getOnlinePlayers().forEach(player -> this.collectionManager.getRewardAutoCorrector().correctRewards(player)));
    }

    public void onDisable() {
        this.commandManager.unregisterCommands();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CollectionManager getCollectionManager() {
        return this.collectionManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }
}

