/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.api.data;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class CollectionData
extends UserDataHolder {
    private final Map<String, Map<String, Long>> cache = Maps.newConcurrentMap();

    public NamespacedId getId() {
        return NamespacedId.fromDefault((String)"collections");
    }

    public void serializeInto(ConfigurationSection data) {
        data.getKeys(false).forEach(key -> data.set(key, null));
        for (Map.Entry<String, Map<String, Long>> entry : this.cache.entrySet()) {
            ConfigurationSection section = data.createSection(entry.getKey());
            for (Map.Entry<String, Long> innerEntry : entry.getValue().entrySet()) {
                section.set(innerEntry.getKey(), (Object)innerEntry.getValue());
            }
        }
    }

    public void initFrom(@Nullable ConfigurationSection data) {
        if (data == null) {
            return;
        }
        for (String key : data.getKeys(false)) {
            ConfigurationSection section = data.getConfigurationSection(key);
            if (section == null) continue;
            ConcurrentMap innerMap = Maps.newConcurrentMap();
            for (String innerKey : section.getKeys(false)) {
                innerMap.put(innerKey, section.getLong(innerKey));
            }
            this.cache.put(key, innerMap);
        }
    }

    public Long getCollectionCount(String category, String collection) {
        return this.cache.getOrDefault(category, Maps.newConcurrentMap()).getOrDefault(collection, 0L);
    }

    public void incrementCollectionCount(String category, String collection, int amount, int maxRequirement) {
        this.dirty.set(true);
        this.cache.computeIfAbsent(category, k -> Maps.newConcurrentMap()).compute(collection, (k, v) -> v == null ? (long)Math.min(amount, maxRequirement) : Math.min(v + (long)amount, (long)maxRequirement));
    }

    public void incrementCollectionCount(String category, String collection, int amount) {
        this.dirty.set(true);
        this.cache.computeIfAbsent(category, k -> Maps.newConcurrentMap()).compute(collection, (k, v) -> v == null ? (long)amount : v + (long)amount);
    }

    public void setDirty() {
        this.dirty.set(true);
    }

    public Map<String, Map<String, Long>> getCache() {
        return this.cache;
    }
}

