/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.collection;

import com.google.common.collect.Lists;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.collections.collection.CategoryReward;
import gg.auroramc.collections.config.CategoriesConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;

public class Category {
    private final CategoriesConfig.CategoryConfig config;
    private final List<CategoryReward> rewards = Lists.newArrayList();
    private final boolean levelingEnabled;
    private final String id;

    public Category(String id, RewardFactory rewardFactory, CategoriesConfig.CategoryConfig config) {
        this.id = id;
        this.config = config;
        if (config.getLevels() == null || config.getLevels().isEmpty()) {
            this.levelingEnabled = false;
            return;
        }
        this.levelingEnabled = true;
        for (CategoriesConfig.LevelConfig levelConfig : config.getLevels().values()) {
            ArrayList<Reward> parsedRewards = new ArrayList<Reward>();
            for (String key : levelConfig.getRewards().getKeys(false)) {
                Optional reward = rewardFactory.createReward(levelConfig.getRewards().getConfigurationSection(key));
                reward.ifPresent(parsedRewards::add);
            }
            this.rewards.add(new CategoryReward(levelConfig.getPercentage(), parsedRewards, levelConfig.getItem()));
        }
        this.rewards.sort(Comparator.comparingDouble(CategoryReward::percentage));
    }

    public List<Reward> getRewards(int prevLevel, int newLevel, int totalLevels) {
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        for (CategoryReward reward : this.rewards) {
            if (!(reward.percentage() > (double)prevLevel / (double)totalLevels * 100.0) || !(reward.percentage() <= (double)newLevel / (double)totalLevels * 100.0)) continue;
            rewards.addAll(reward.rewards());
        }
        return rewards;
    }

    public List<Reward> getRewards(int level, int totalLevels) {
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        for (CategoryReward reward : this.rewards) {
            if (!(reward.percentage() <= (double)level / (double)totalLevels * 100.0)) continue;
            rewards.addAll(reward.rewards());
        }
        return rewards;
    }

    public boolean hasPermission(Player player) {
        return this.config.getPermission() == null || player.hasPermission(this.config.getPermission());
    }

    public CategoriesConfig.CategoryConfig getConfig() {
        return this.config;
    }

    public List<CategoryReward> getRewards() {
        return this.rewards;
    }

    public boolean isLevelingEnabled() {
        return this.levelingEnabled;
    }

    public String getId() {
        return this.id;
    }
}

