/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.collection;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.IntervalMatcherConfig;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.levels.MatcherManager;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardExecutor;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.api.data.CollectionData;
import gg.auroramc.collections.api.event.CollectionLevelUpEvent;
import gg.auroramc.collections.config.CollectionConfig;
import gg.auroramc.collections.config.Config;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import gg.auroramc.collections.util.RomanNumber;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class Collection {
    private final CollectionConfig config;
    private final String id;
    private final String category;
    private final MatcherManager levelMatcher;
    private final AuroraCollections plugin;

    public Collection(AuroraCollections plugin, CollectionConfig config, String category, String id) {
        this.plugin = plugin;
        this.config = config;
        this.category = category;
        this.id = id;
        this.levelMatcher = new MatcherManager(plugin.getCollectionManager().getRewardFactory());
        Config globalConfig = plugin.getConfigManager().getConfig();
        LinkedHashMap<String, IntervalMatcherConfig> collectionMatchers = new LinkedHashMap<String, IntervalMatcherConfig>();
        if (config.getUseGlobalLevelMatchers().booleanValue()) {
            collectionMatchers.putAll(globalConfig.getGlobalLevelMatchers());
            collectionMatchers.putAll(config.getLevelMatchers());
        } else {
            collectionMatchers.putAll(config.getLevelMatchers());
        }
        this.levelMatcher.reload(collectionMatchers, config.getCustomLevels());
    }

    public boolean hasPermission(Player player) {
        boolean categoryHasPermission = this.plugin.getCollectionManager().getCategory(this.category).hasPermission(player);
        return categoryHasPermission && (this.config.getPermission() == null || player.hasPermission(this.config.getPermission()));
    }

    public int getMaxLevel() {
        return this.config.getRequirements().size();
    }

    public int getPlayerLevel(Player player) {
        CollectionData data = (CollectionData)AuroraAPI.getUserManager().getUser(player).getData(CollectionData.class);
        Long progress = data.getCollectionCount(this.category, this.id);
        List<Integer> requirements = this.config.getRequirements();
        for (int i = requirements.size() - 1; i >= 0; --i) {
            if (progress < (long)requirements.get(i).intValue()) continue;
            return i + 1;
        }
        return 0;
    }

    public long getRequiredAmount(long level) {
        return ((long)this.config.getRequirements().size() < level ? this.config.getRequirements().getLast() : this.config.getRequirements().get((int)Math.max(level - 1L, 0L))).intValue();
    }

    public void resetProgress(Player player) {
        AuroraUser user = AuroraAPI.getUserManager().getUser(player);
        if (!user.isLoaded()) {
            return;
        }
        CollectionData data = (CollectionData)user.getData(CollectionData.class);
        if (data.getCache().get(this.category) == null) {
            return;
        }
        data.getCache().get(this.category).remove(this.id);
        data.setDirty();
        AuroraAPI.getLeaderboards().updateUser(user, new String[]{this.category + "_" + this.id});
    }

    public boolean isMaxed(Player player) {
        return this.getPlayerLevel(player) >= this.getMaxLevel();
    }

    public boolean isUnlocked(Player player) {
        return this.getCount(player) > 0L;
    }

    public void removeProgress(Player player, int amount) {
        AuroraUser user = AuroraAPI.getUserManager().getUser(player);
        if (!user.isLoaded()) {
            return;
        }
        CollectionData data = (CollectionData)user.getData(CollectionData.class);
        if (data.getCache().get(this.category) == null) {
            return;
        }
        data.getCache().get(this.category).compute(this.id, (k, current) -> Math.max(0L, (current == null ? 0L : current) - (long)amount));
        if (data.getCache().get(this.category).get(this.id) == 0L) {
            data.getCache().get(this.category).remove(this.id);
        }
        data.setDirty();
        AuroraAPI.getLeaderboards().updateUser(user, new String[]{this.category + "_" + this.id});
    }

    public void setProgress(Player player, int amount) {
        AuroraUser user = AuroraAPI.getUserManager().getUser(player);
        if (!user.isLoaded()) {
            return;
        }
        CollectionData data = (CollectionData)user.getData(CollectionData.class);
        Long current = data.getCollectionCount(this.category, this.id);
        if (amount == 0) {
            this.resetProgress(player);
            return;
        }
        if ((long)amount <= current) {
            data.getCache().computeIfAbsent(this.category, k -> Maps.newConcurrentMap()).put(this.id, Long.valueOf(amount));
            data.setDirty();
        } else {
            this.progress(player, null, Long.valueOf((long)amount - current).intValue(), null);
        }
        AuroraAPI.getLeaderboards().updateUser(user, new String[]{this.category + "_" + this.id});
    }

    private int getMultiplier(TypeId typeId, String trigger) {
        int multiplier = 1;
        if (trigger == null) {
            return multiplier;
        }
        Optional<CollectionConfig.ParsedMultiplier> entry = this.config.getParsedMultipliers().stream().filter(m -> m.getTypes().contains(typeId)).filter(m -> m.getTriggers().contains(trigger)).findFirst();
        if (entry.isPresent()) {
            multiplier = entry.get().getValue();
        }
        return multiplier;
    }

    public void displayDiscoverMessage(Player player, int oldLevel, int newLevel) {
        Config.GenericSound sound;
        List<Placeholder<?>> placeholders = this.getPlaceholders(player, oldLevel, newLevel);
        Placeholder rawName = Placeholder.of((String)"{collection_name_raw}", (String)PlainTextComponentSerializer.plainText().serialize(Text.component((String)this.config.getName(), (Placeholder[])new Placeholder[0])));
        placeholders.add(rawName);
        Config.GenericMessage message = this.plugin.getConfigManager().getConfig().getDiscoverMessage();
        if (message.getEnabled().booleanValue()) {
            List<String> messageLines = message.getMessage();
            TextComponent.Builder text = Component.text();
            int count = 0;
            for (String line : messageLines) {
                text.append(Text.component((Player)player, (String)line, placeholders));
                if (messageLines.size() == ++count) continue;
                text.append((Component)Component.newline());
            }
            if (message.getOpenMenuWhenClicked().booleanValue()) {
                text.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/" + this.plugin.getConfigManager().getConfig().getCommandAliases().getCollections().getFirst() + " " + this.plugin.getConfigManager().getConfig().getCommandAliases().getProgression().getFirst() + " " + this.category + " " + this.id)));
            }
            player.sendMessage((ComponentLike)text);
        }
        if ((sound = this.plugin.getConfigManager().getConfig().getDiscoverSound()).getEnabled().booleanValue()) {
            NamespacedKey key = NamespacedKey.fromString((String)sound.getSound());
            if (key != null) {
                Sound realSound = (Sound)Registry.SOUNDS.get(key);
                if (realSound != null) {
                    player.playSound(player.getLocation(), realSound, sound.getVolume().floatValue(), sound.getPitch().floatValue());
                }
            } else {
                AuroraCollections.logger().warning("Invalid sound key: " + sound.getSound());
            }
        }
    }

    public int getMaxRequirement() {
        Integer last = this.config.getRequirements().getLast();
        if (last == null) {
            return 0;
        }
        return last;
    }

    public synchronized void progress(Player player, @Nullable TypeId type, int amount, String trigger) {
        if (type != null && !this.config.getParsedTypes().contains(type)) {
            return;
        }
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            return;
        }
        int oldLevel = this.getPlayerLevel(player);
        CollectionData data = (CollectionData)AuroraAPI.getUserManager().getUser(player).getData(CollectionData.class);
        boolean displayDiscoverMessage = data.getCollectionCount(this.category, this.id) == 0L;
        int actualAmount = amount * this.getMultiplier(type, trigger);
        if (this.plugin.getConfigManager().getConfig().getLimitProgressToMaxRequirement().booleanValue()) {
            data.incrementCollectionCount(this.category, this.id, actualAmount, this.getMaxRequirement());
        } else {
            data.incrementCollectionCount(this.category, this.id, actualAmount);
        }
        int newLevel = this.getPlayerLevel(player);
        if (displayDiscoverMessage) {
            this.displayDiscoverMessage(player, oldLevel, newLevel);
        }
        if (newLevel <= oldLevel) {
            return;
        }
        Config mainConfig = this.plugin.getConfigManager().getConfig();
        Placeholder rawName = Placeholder.of((String)"{collection_name_raw}", (String)PlainTextComponentSerializer.plainText().serialize(Text.component((String)this.config.getName(), (Placeholder[])new Placeholder[0])));
        for (int i = oldLevel + 1; i <= newLevel; ++i) {
            LevelMatcher matcher = this.levelMatcher.getBestMatcher(i);
            List<Placeholder<?>> placeholders = this.getPlaceholders(player, i - 1, i);
            placeholders.add(rawName);
            TextComponent.Builder text = Component.text();
            List<String> messageLines = mainConfig.getLevelUpMessage().getMessage();
            List rewards = matcher.computeRewards(i);
            int count = 0;
            for (String line : messageLines) {
                ++count;
                if (line.equals("component:rewards")) {
                    if (!rewards.isEmpty()) {
                        text.append(Text.component((Player)player, (String)mainConfig.getDisplayComponents().get("rewards").getTitle(), placeholders));
                    }
                    for (Reward reward : rewards) {
                        text.append((Component)Component.newline());
                        String display = mainConfig.getDisplayComponents().get("rewards").getLine().replace("{reward}", reward.getDisplay(player, placeholders));
                        text.append(Text.component((Player)player, (String)display, placeholders));
                    }
                } else {
                    text.append(Text.component((Player)player, (String)line, placeholders));
                }
                if (messageLines.size() == count) continue;
                text.append((Component)Component.newline());
            }
            if (mainConfig.getLevelUpSound().getEnabled().booleanValue()) {
                Config.GenericSound sound = mainConfig.getLevelUpSound();
                NamespacedKey key = NamespacedKey.fromString((String)sound.getSound());
                if (key != null) {
                    Sound realSound = (Sound)Registry.SOUNDS.get(key);
                    if (realSound != null) {
                        player.playSound(player.getLocation(), realSound, sound.getVolume().floatValue(), sound.getPitch().floatValue());
                    }
                } else {
                    AuroraCollections.logger().warning("Invalid sound key: " + sound.getSound());
                }
            }
            if (mainConfig.getLevelUpMessage().getEnabled().booleanValue()) {
                if (mainConfig.getLevelUpMessage().getOpenMenuWhenClicked().booleanValue()) {
                    text.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/" + mainConfig.getCommandAliases().getCollections().get(0) + " " + mainConfig.getCommandAliases().getProgression().get(0) + " " + this.category + " " + this.id)));
                }
                Chat.sendMessage((Player)player, (Component)text.build());
            }
            RewardExecutor.execute((List)rewards, (Player)player, (long)i, placeholders);
            Bukkit.getPluginManager().callEvent((Event)new CollectionLevelUpEvent(player, this, i));
        }
    }

    private List<Placeholder<?>> getPlaceholders(Player player, long oldLevel, long newLevel) {
        long requirement = this.getRequiredAmount(newLevel);
        CollectionMenuConfig pConfig = this.plugin.getConfigManager().getCollectionMenuConfig();
        AuroraUser user = AuroraAPI.getUser((UUID)player.getUniqueId());
        CollectionData data = (CollectionData)user.getData(CollectionData.class);
        long currentProgress = Math.min(data.getCollectionCount(this.category, this.id), requirement);
        CollectionMenuConfig.ProgressBar bar = pConfig.getProgressBar();
        Integer pcs = bar.getLength();
        double completedPercent = Math.min((double)currentProgress / (double)requirement, 1.0);
        int completedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * completedPercent)).intValue();
        int remainingPcs = pcs - completedPcs;
        CollectionMenuConfig config = this.plugin.getConfigManager().getCollectionMenuConfig();
        Boolean roman = config.getForceRomanNumerals();
        String oldLevel2 = roman != false ? RomanNumber.toRoman(oldLevel) : String.valueOf(oldLevel);
        String newLevel2 = roman != false ? RomanNumber.toRoman(newLevel) : String.valueOf(newLevel);
        String menuTitle = this.config.getMenuTitle() == null ? this.config.getName() : this.config.getMenuTitle();
        ArrayList placeholders = Lists.newArrayList((Object[])new Placeholder[]{Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{prev_level}", (String)oldLevel2), Placeholder.of((String)"{prev_level_raw}", (Number)oldLevel), Placeholder.of((String)"{prev_level_formatted}", (String)(roman != false ? oldLevel2 : AuroraAPI.formatNumber((long)oldLevel))), Placeholder.of((String)"{prev_level_roman}", (String)RomanNumber.toRoman(oldLevel)), Placeholder.of((String)"{level}", (String)newLevel2), Placeholder.of((String)"{level_raw}", (Number)newLevel), Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(newLevel)), Placeholder.of((String)"{level_formatted}", (String)(roman != false ? newLevel2 : AuroraAPI.formatNumber((long)newLevel))), Placeholder.of((String)"{collection}", (String)this.id), Placeholder.of((String)"{collection_name}", (String)this.config.getName()), Placeholder.of((String)"{collection_title}", (String)menuTitle), Placeholder.of((String)"{category}", (String)this.category), Placeholder.of((String)"{category_name}", (String)this.plugin.getConfigManager().getCategoriesConfig().getCategories().get(this.category).getName()), Placeholder.of((String)"{progressbar}", (String)(bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r")), Placeholder.of((String)"{progress_percent}", (Number)Math.round(completedPercent * 100.0)), Placeholder.of((String)"{current}", (Number)currentProgress), Placeholder.of((String)"{current_formatted}", (String)AuroraAPI.formatNumber((long)currentProgress)), Placeholder.of((String)"{required}", (Number)requirement), Placeholder.of((String)"{required_formatted}", (String)AuroraAPI.formatNumber((long)requirement)), Placeholder.of((String)"{total}", (Number)data.getCollectionCount(this.category, this.id)), Placeholder.of((String)"{total_formatted}", (String)AuroraAPI.formatNumber((long)data.getCollectionCount(this.category, this.id))), Placeholder.of((String)"{total_short}", (String)AuroraAPI.formatNumberShort((double)data.getCollectionCount(this.category, this.id).longValue()))});
        String boardName = this.category + "_" + this.id;
        LbEntry lb = (LbEntry)user.getLeaderboardEntries().get(boardName);
        LeaderboardExpansion lbm = AuroraAPI.getLeaderboards();
        if (lb != null && lb.getPosition() != 0L) {
            placeholders.add(Placeholder.of((String)"{lb_position}", (String)AuroraAPI.formatNumber((long)lb.getPosition())));
            placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)AuroraAPI.formatNumber((double)Math.min((double)lb.getPosition() / (double)Math.max(1L, AuroraAPI.getLeaderboards().getBoardSize(boardName)) * 100.0, 100.0))));
            placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max(Math.max(lb.getPosition(), (long)Bukkit.getOnlinePlayers().size()), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        } else {
            placeholders.add(Placeholder.of((String)"{lb_position}", (String)lbm.getEmptyPlaceholder()));
            placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)lbm.getEmptyPlaceholder()));
            placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max((long)Bukkit.getOnlinePlayers().size(), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        }
        return placeholders;
    }

    public List<Placeholder<?>> getPlaceholders(Player player, long level) {
        level = Math.max(1L, level);
        return this.getPlaceholders(player, level - 1L, level);
    }

    public String getMenuTitle() {
        return this.config.getMenuTitle() == null ? this.config.getName() : this.config.getMenuTitle();
    }

    public void progress(Player player, TypeId type) {
        this.progress(player, type, 1, null);
    }

    public Long getCount(Player player) {
        return ((CollectionData)AuroraAPI.getUserManager().getUser(player).getData(CollectionData.class)).getCollectionCount(this.category, this.id);
    }

    public CollectionConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public MatcherManager getLevelMatcher() {
        return this.levelMatcher;
    }

    public AuroraCollections getPlugin() {
        return this.plugin;
    }
}

