/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.collection;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.CommandReward;
import gg.auroramc.aurora.api.reward.ItemReward;
import gg.auroramc.aurora.api.reward.MoneyReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardAutoCorrector;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.aurora.api.reward.RewardExecutor;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.api.event.CollectionLevelUpEvent;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.CategoryReward;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.config.CategoriesConfig;
import gg.auroramc.collections.config.CollectionConfig;
import gg.auroramc.collections.config.Config;
import gg.auroramc.collections.config.menu.CategoriesMenuConfig;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import gg.auroramc.collections.hooks.HookManager;
import gg.auroramc.collections.hooks.worldguard.WorldGuardHook;
import gg.auroramc.collections.listener.BlockBreakListener;
import gg.auroramc.collections.listener.DamageListener;
import gg.auroramc.collections.listener.EntityKillListener;
import gg.auroramc.collections.listener.FishingListener;
import gg.auroramc.collections.listener.HarvestingListener;
import gg.auroramc.collections.listener.PlayerKillListener;
import gg.auroramc.collections.listener.ShearListener;
import gg.auroramc.collections.listener.VillagerTradeListener;
import gg.auroramc.collections.reward.corrector.CommandCorrector;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CollectionManager
implements Listener {
    private final AuroraCollections plugin;
    private final Map<String, Map<String, Collection>> categories = Maps.newConcurrentMap();
    private final RewardFactory rewardFactory = new RewardFactory();
    private final RewardAutoCorrector rewardAutoCorrector = new RewardAutoCorrector();
    private final Map<String, Category> categoryMap = Maps.newConcurrentMap();

    public CollectionManager(AuroraCollections plugin) {
        this.plugin = plugin;
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"command"), CommandReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"money"), MoneyReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"item"), ItemReward.class);
        this.rewardAutoCorrector.registerCorrector(NamespacedId.fromDefault((String)"command"), (RewardCorrector)new CommandCorrector(plugin));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockBreakListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new EntityKillListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new FishingListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new HarvestingListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerKillListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new ShearListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new DamageListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new VillagerTradeListener(plugin), (Plugin)plugin);
    }

    public java.util.Collection<Category> getCategories() {
        return this.categoryMap.values();
    }

    public List<Collection> getAllCollections() {
        return this.categories.values().stream().flatMap(map -> map.values().stream()).toList();
    }

    public Category getCategory(String category) {
        return this.categoryMap.get(category);
    }

    public java.util.Collection<Collection> getCollectionsForCategory(String category) {
        return this.categories.get(category).values();
    }

    public int getMaxCategoryLevel(String category) {
        if (!this.categories.containsKey(category)) {
            return 0;
        }
        return this.categories.get(category).values().stream().mapToInt(Collection::getMaxLevel).sum();
    }

    public int getCategoryLevel(String category, Player player) {
        if (!this.categories.containsKey(category)) {
            return 0;
        }
        return this.categories.get(category).values().stream().mapToInt(c -> c.getPlayerLevel(player)).sum();
    }

    public double getCategoryCompletionPercent(String category, Player player) {
        return (double)this.getCategoryLevel(category, player) / Math.max((double)this.getMaxCategoryLevel(category), 1.0);
    }

    public List<Collection> getCollectionsByCategory(String category) {
        return List.copyOf(this.categories.getOrDefault(category, Map.of()).values());
    }

    public Collection getCollection(String category, String name) {
        Map<String, Collection> collectionMap = this.categories.get(category);
        if (collectionMap != null) {
            return collectionMap.get(name);
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.categories.containsKey(category);
    }

    public void progressCollections(Player player, TypeId type, int amount, String ... triggers) {
        if (!player.hasPermission("aurora.collections.use")) {
            return;
        }
        if (this.plugin.getConfigManager().getConfig().getPreventCreativeMode().booleanValue() && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (!AuroraAPI.getUserManager().getUser(player).isLoaded()) {
            return;
        }
        if (HookManager.isEnabled(WorldGuardHook.class) && HookManager.getHook(WorldGuardHook.class).isBlocked(player, player.getLocation())) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            HashSet<CallSite> toUpdate = new HashSet<CallSite>();
            for (Map.Entry<String, Map<String, Collection>> category : this.categories.entrySet()) {
                if (!this.getCategory(category.getKey()).hasPermission(player)) continue;
                for (Collection collection : category.getValue().values()) {
                    String firstMatch;
                    if (!collection.hasPermission(player) || (firstMatch = (String)Arrays.stream(triggers).filter(trigger -> collection.getConfig().getParsedTriggers().contains(trigger)).findFirst().orElse(null)) == null) continue;
                    collection.progress(player, type, amount, firstMatch);
                    toUpdate.add((CallSite)((Object)(collection.getCategory() + "_" + collection.getId())));
                    toUpdate.add((CallSite)((Object)("cc_" + collection.getCategory())));
                }
            }
            if (!toUpdate.isEmpty()) {
                AuroraUser user = AuroraAPI.getUserManager().getUser(player);
                if (!user.isLoaded()) {
                    return;
                }
                AuroraAPI.getLeaderboards().updateUser(user, toUpdate.toArray(new String[0]));
            }
        });
    }

    public void reloadCollections() {
        this.categoryMap.clear();
        this.categories.clear();
        Map<String, Map<String, CollectionConfig>> config = this.plugin.getConfigManager().getCollections();
        for (Map.Entry<String, Map<String, CollectionConfig>> entry : config.entrySet()) {
            LinkedHashMap categoryMap = Maps.newLinkedHashMap();
            for (Map.Entry collection : entry.getValue().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                categoryMap.put((String)collection.getKey(), new Collection(this.plugin, (CollectionConfig)((Object)collection.getValue()), entry.getKey(), (String)collection.getKey()));
            }
            this.categories.put(entry.getKey(), categoryMap);
        }
        for (Map.Entry<String, Object> entry : this.plugin.getConfigManager().getCategoriesConfig().getCategories().entrySet()) {
            this.categoryMap.put(entry.getKey(), new Category(entry.getKey(), this.rewardFactory, (CategoriesConfig.CategoryConfig)entry.getValue()));
            if (this.categories.containsKey(entry.getKey())) continue;
            this.categories.put(entry.getKey(), Maps.newConcurrentMap());
        }
    }

    @EventHandler
    public void onUserLoaded(AuroraUserLoadedEvent e) {
        CompletableFuture.runAsync(() -> this.rewardAutoCorrector.correctRewards(e.getUser().getPlayer()));
    }

    @EventHandler
    public void onCollectionLevelUp(CollectionLevelUpEvent e) {
        String categoryId = e.getCollection().getCategory();
        Category category = this.categoryMap.get(categoryId);
        if (!category.isLevelingEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        int level = this.getCategoryLevel(categoryId, player);
        List<Reward> rewards = category.getRewards(level - 1, level, this.getMaxCategoryLevel(categoryId));
        if (rewards.isEmpty()) {
            return;
        }
        double highestPercent = 0.0;
        double currentPercent = this.getCategoryCompletionPercent(categoryId, player) * 100.0;
        for (CategoryReward r : category.getRewards()) {
            if (!(r.percentage() > highestPercent) || !(currentPercent >= r.percentage())) continue;
            highestPercent = r.percentage();
        }
        List<Placeholder> placeholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{category_name}", (String)this.categoryMap.get(categoryId).getConfig().getName()), Placeholder.of((String)"{category_id}", (String)categoryId), Placeholder.of((String)"{percent}", (String)AuroraAPI.formatNumber((double)highestPercent)));
        Config.GenericMessage lvlUpMsg = this.plugin.getConfigManager().getConfig().getCategoryLevelUpMessage();
        int count = 0;
        if (lvlUpMsg.getEnabled().booleanValue()) {
            TextComponent.Builder text = Component.text();
            List<String> messageLines = lvlUpMsg.getMessage();
            Config mainConfig = this.plugin.getConfigManager().getConfig();
            for (String line : messageLines) {
                ++count;
                if (line.equals("component:rewards")) {
                    if (!rewards.isEmpty()) {
                        text.append(Text.component((Player)e.getPlayer(), (String)mainConfig.getDisplayComponents().get("rewards").getTitle(), placeholders));
                    }
                    for (Reward reward : rewards) {
                        text.append((Component)Component.newline());
                        String display = mainConfig.getDisplayComponents().get("rewards").getLine().replace("{reward}", reward.getDisplay(player, placeholders));
                        text.append(Text.component((Player)player, (String)display, placeholders));
                    }
                } else {
                    text.append(Text.component((Player)player, (String)line, placeholders));
                }
                if (count == messageLines.size()) continue;
                text.append((Component)Component.newline());
            }
            if (lvlUpMsg.getOpenMenuWhenClicked().booleanValue()) {
                text.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/" + mainConfig.getCommandAliases().getCollections().get(0) + " " + mainConfig.getCommandAliases().getProgression().get(0) + " " + category.getId())));
            }
            Chat.sendMessage((Player)player, (Component)text.build());
        }
        RewardExecutor.execute(rewards, (Player)player, (long)level, placeholders);
    }

    public List<Placeholder<?>> getCategoryPlaceholders(String category, Player player) {
        ArrayList placeholders = new ArrayList(13);
        String categoryName = this.plugin.getConfigManager().getCategoriesConfig().getCategories().get(category).getName();
        double percentRaw = this.getCategoryCompletionPercent(category, player);
        String currentPercentage = AuroraAPI.formatNumber((double)(percentRaw * 100.0));
        String boardName = "cc_" + category;
        LbEntry lb = (LbEntry)AuroraAPI.getUser((UUID)player.getUniqueId()).getLeaderboardEntries().get(boardName);
        LeaderboardExpansion lbm = AuroraAPI.getLeaderboards();
        if (lb != null && lb.getPosition() != 0L) {
            placeholders.add(Placeholder.of((String)"{lb_position}", (String)AuroraAPI.formatNumber((long)lb.getPosition())));
            placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)AuroraAPI.formatNumber((double)Math.min((double)lb.getPosition() / (double)Math.max(1L, AuroraAPI.getLeaderboards().getBoardSize(boardName)) * 100.0, 100.0))));
            placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max(Math.max(lb.getPosition(), (long)Bukkit.getOnlinePlayers().size()), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        } else {
            placeholders.add(Placeholder.of((String)"{lb_position}", (String)lbm.getEmptyPlaceholder()));
            placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)lbm.getEmptyPlaceholder()));
            placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max((long)Bukkit.getOnlinePlayers().size(), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        }
        long totalCollected = this.getCollectionsByCategory(category).stream().mapToLong(collection -> collection.getCount(player)).sum();
        placeholders.add(Placeholder.of((String)"{total_formatted}", (String)AuroraAPI.formatNumber((long)totalCollected)));
        placeholders.add(Placeholder.of((String)"{total}", (Number)totalCollected));
        placeholders.add(Placeholder.of((String)"{total_short}", (String)AuroraAPI.formatNumberShort((double)totalCollected)));
        List<Collection> collectionsInCategory = this.plugin.getCollectionManager().getCollectionsByCategory(category);
        long maxedCollections = collectionsInCategory.stream().filter(c -> c.isMaxed(player)).count();
        long unlockedCollections = collectionsInCategory.stream().filter(c -> c.isUnlocked(player)).count();
        double maxedPercent = Math.min((double)maxedCollections / (double)collectionsInCategory.size(), 1.0);
        double unlockedPercent = Math.min((double)unlockedCollections / (double)collectionsInCategory.size(), 1.0);
        CategoriesMenuConfig config = this.plugin.getConfigManager().getCategoriesMenuConfig();
        CollectionMenuConfig.ProgressBar bar = config.getProgressBar();
        Integer pcs = bar.getLength();
        double completedPercent = Math.min(percentRaw, 1.0);
        int completedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * completedPercent)).intValue();
        int remainingPcs = pcs - completedPcs;
        double maxedCompletedPercent = Math.min(maxedPercent, 1.0);
        int maxedCompletedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * maxedCompletedPercent)).intValue();
        int maxedRemainingPcs = pcs - maxedCompletedPcs;
        int unlockedCompletedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * unlockedPercent)).intValue();
        int unlockedRemainingPcs = pcs - unlockedCompletedPcs;
        placeholders.add(Placeholder.of((String)"{name}", (String)categoryName));
        placeholders.add(Placeholder.of((String)"{progress_percent}", (String)currentPercentage));
        placeholders.add(Placeholder.of((String)"{progressbar}", (String)(bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r")));
        placeholders.add(Placeholder.of((String)"{maxed_progressbar}", (String)(bar.getFilledCharacter().repeat(maxedCompletedPcs) + bar.getUnfilledCharacter().repeat(maxedRemainingPcs) + "&r")));
        placeholders.add(Placeholder.of((String)"{maxed_collection_count}", (String)AuroraAPI.formatNumber((long)maxedCollections)));
        placeholders.add(Placeholder.of((String)"{total_collection_count}", (String)AuroraAPI.formatNumber((long)collectionsInCategory.size())));
        placeholders.add(Placeholder.of((String)"{maxed_progress_percent}", (String)AuroraAPI.formatNumber((double)(maxedPercent * 100.0))));
        placeholders.add(Placeholder.of((String)"{unlocked_collection_count}", (String)AuroraAPI.formatNumber((long)unlockedCollections)));
        placeholders.add(Placeholder.of((String)"{unlocked_progressbar}", (String)(bar.getFilledCharacter().repeat(unlockedCompletedPcs) + bar.getUnfilledCharacter().repeat(unlockedRemainingPcs) + "&r")));
        placeholders.add(Placeholder.of((String)"{unlocked_progress_percent}", (String)AuroraAPI.formatNumber((double)(unlockedPercent * 100.0))));
        return placeholders;
    }

    public List<Placeholder<?>> getGlobalPlaceholders(Player player) {
        ArrayList placeholders = new ArrayList();
        List<Collection> allCollections = this.plugin.getCollectionManager().getAllCollections();
        long unlockedCollections = allCollections.stream().filter(c -> c.isUnlocked(player)).count();
        int totalCollections = allCollections.size();
        double unlockedPercent = totalCollections > 0 ? (double)unlockedCollections / (double)totalCollections : 0.0;
        CategoriesMenuConfig config = this.plugin.getConfigManager().getCategoriesMenuConfig();
        CollectionMenuConfig.ProgressBar bar = config.getProgressBar();
        Integer pcs = bar.getLength();
        int completedPcs = (int)Math.floor((double)pcs.intValue() * unlockedPercent);
        int remainingPcs = pcs - completedPcs;
        placeholders.add(Placeholder.of((String)"{unlocked_total_count}", (String)AuroraAPI.formatNumber((long)unlockedCollections)));
        placeholders.add(Placeholder.of((String)"{total_all_collection_count}", (String)AuroraAPI.formatNumber((long)totalCollections)));
        placeholders.add(Placeholder.of((String)"{unlocked_total_progressbar}", (String)(bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r")));
        placeholders.add(Placeholder.of((String)"{unlocked_total_percent}", (String)AuroraAPI.formatNumber((double)(unlockedPercent * 100.0))));
        return placeholders;
    }

    public RewardFactory getRewardFactory() {
        return this.rewardFactory;
    }

    public RewardAutoCorrector getRewardAutoCorrector() {
        return this.rewardAutoCorrector;
    }
}

