/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.command;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.libs.acf.BaseCommand;
import gg.auroramc.collections.libs.acf.annotation.CommandAlias;
import gg.auroramc.collections.libs.acf.annotation.CommandCompletion;
import gg.auroramc.collections.libs.acf.annotation.CommandPermission;
import gg.auroramc.collections.libs.acf.annotation.Default;
import gg.auroramc.collections.libs.acf.annotation.Description;
import gg.auroramc.collections.libs.acf.annotation.Flags;
import gg.auroramc.collections.libs.acf.annotation.Subcommand;
import gg.auroramc.collections.menu.CategoryMenu;
import gg.auroramc.collections.menu.CategoryRewardsMenu;
import gg.auroramc.collections.menu.CollectionsMenu;
import gg.auroramc.collections.menu.ProgressionMenu;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%collectionsAlias")
public class CollectionsCommand
extends BaseCommand {
    private final AuroraCollections plugin;

    public CollectionsCommand(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    @Default
    @Description(value="Opens the collections menu")
    @CommandPermission(value="aurora.collections.use")
    public void onMenu(Player player) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYetSelf(), (Placeholder[])new Placeholder[0]);
            return;
        }
        new CategoryMenu(player, this.plugin).open();
    }

    @Subcommand(value="reload")
    @Description(value="Reloads the plugin configs and applies reward auto correctors to players")
    @CommandPermission(value="aurora.collections.admin.reload")
    public void onReload(CommandSender sender) {
        this.plugin.reload();
        Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getReloaded(), (Placeholder[])new Placeholder[0]);
    }

    @Subcommand(value="open")
    @Description(value="Opens the collections menu for another player in a specific category")
    @CommandCompletion(value="@players @categories|none true|false")
    @CommandPermission(value="aurora.collections.admin.open")
    public void onOpenMenu(CommandSender sender, @Flags(value="other") Player target, @Default(value="none") String category, @Default(value="false") Boolean silent) {
        if (category.equals("none")) {
            new CategoryMenu(target, this.plugin).open();
        } else {
            new CollectionsMenu(target, this.plugin, category).open();
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getMenuOpened(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName())});
        }
    }

    @Subcommand(value="%progressionAlias")
    @Description(value="Opens the collection progression menu for another player")
    @CommandCompletion(value="@categories @collections|none")
    @CommandPermission(value="aurora.collections.use.open")
    public void onOpenProgressionMenu(Player sender, String category, @Default(value="none") String collectionId) {
        if (collectionId.equals("none")) {
            if (!this.plugin.getCollectionManager().hasCategory(category)) {
                return;
            }
            if (this.plugin.getCollectionManager().getCategory(category).isLevelingEnabled()) {
                if (!this.plugin.getCollectionManager().getCategory(category).hasPermission(sender)) {
                    Chat.sendMessage((Player)sender, (String)this.plugin.getConfigManager().getMessageConfig().getNoPermission(), (Placeholder[])new Placeholder[0]);
                    return;
                }
                new CategoryRewardsMenu(sender, this.plugin, category).open();
            }
        } else {
            Collection collection = this.plugin.getCollectionManager().getCollection(category, collectionId);
            if (collection == null) {
                return;
            }
            if (!collection.hasPermission(sender)) {
                Chat.sendMessage((Player)sender, (String)this.plugin.getConfigManager().getMessageConfig().getNoPermission(), (Placeholder[])new Placeholder[0]);
                return;
            }
            new ProgressionMenu(sender, this.plugin, collection).open();
        }
    }

    @Subcommand(value="add")
    @Description(value="Adds progress to a player's collection")
    @CommandCompletion(value="@players @categories @collections|all @range:1-1000 true|false")
    @CommandPermission(value="aurora.collections.admin.add")
    public void onAdd(CommandSender sender, @Flags(value="other") Player target, String category, String collectionId, Integer number, @Default(value="false") Boolean silent) {
        List<Collection> collections = this.getCollection(sender, category, collectionId);
        if (collections == null) {
            return;
        }
        List<Collection> validCollections = collections.stream().filter(c -> c.hasPermission(target)).toList();
        for (Collection collection : validCollections) {
            collection.progress(target, null, number, null);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getAddSuccess(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{number}", (String)AuroraAPI.formatNumber((long)number.intValue())), Placeholder.of((String)"{collection}", (String)String.join((CharSequence)", ", validCollections.stream().map(Collection::getId).toList()))});
        }
    }

    @Subcommand(value="remove")
    @Description(value="Removes progress from a player's collection")
    @CommandCompletion(value="@players @categories @collections|all @range:1-1000 true|false")
    @CommandPermission(value="aurora.collections.admin.remove")
    public void onRemove(CommandSender sender, @Flags(value="other") Player target, String category, String collectionId, Integer number, @Default(value="false") Boolean silent) {
        List<Collection> collections = this.getCollection(sender, category, collectionId);
        if (collections == null) {
            return;
        }
        for (Collection collection : collections) {
            collection.removeProgress(target, number);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getRemoveSuccess(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{number}", (String)AuroraAPI.formatNumber((long)number.intValue())), Placeholder.of((String)"{collection}", (String)String.join((CharSequence)", ", collections.stream().map(Collection::getId).toList()))});
        }
    }

    @Subcommand(value="set")
    @Description(value="Sets progress of a player's collection")
    @CommandCompletion(value="@players @categories @collections|all @range:0-1000 true|false")
    @CommandPermission(value="aurora.collections.admin.set")
    public void onSet(CommandSender sender, @Flags(value="other") Player target, String category, String collectionId, Integer number, @Default(value="false") Boolean silent) {
        List<Collection> collections = this.getCollection(sender, category, collectionId);
        if (collections == null) {
            return;
        }
        for (Collection collection : collections) {
            collection.setProgress(target, number);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getSetSuccess(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{number}", (String)AuroraAPI.formatNumber((long)number.intValue())), Placeholder.of((String)"{collection}", (String)String.join((CharSequence)", ", collections.stream().map(Collection::getId).toList()))});
        }
    }

    @Subcommand(value="reset")
    @Description(value="Resets progress of a player's collection/category")
    @CommandCompletion(value="@players @categories|all @collections|all true|false")
    @CommandPermission(value="aurora.collections.admin.reset")
    public void onReset(CommandSender sender, @Flags(value="other") Player target, String category, @Default(value="all") String collectionId, @Default(value="false") Boolean silent) {
        List<Collection> collections = this.getCollection(sender, category, collectionId);
        if (collections == null) {
            return;
        }
        for (Collection collection : collections) {
            collection.resetProgress(target);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getResetSuccess(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{collection}", (String)String.join((CharSequence)", ", collections.stream().map(Collection::getId).toList()))});
        }
    }

    private List<Collection> getCollection(CommandSender sender, String category, String collectionId) {
        if (category.equals("all")) {
            return this.plugin.getCollectionManager().getAllCollections();
        }
        if (!this.plugin.getCollectionManager().hasCategory(category)) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getCategoryNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{category}", (String)category)});
            return null;
        }
        if (collectionId.equals("all")) {
            return this.plugin.getCollectionManager().getCollectionsByCategory(category);
        }
        Collection collection = this.plugin.getCollectionManager().getCollection(category, collectionId);
        if (collection == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getCollectionNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{collection}", (String)collectionId)});
            return null;
        }
        return List.of(collection);
    }
}

