/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.collections.AuroraCollections;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CategoriesConfig
extends AuroraConfig {
    private Map<String, CategoryConfig> categories;

    public CategoriesConfig(AuroraCollections plugin) {
        super(CategoriesConfig.getFile(plugin));
    }

    public static File getFile(AuroraCollections plugin) {
        return new File(plugin.getDataFolder(), "categories.yml");
    }

    public static void saveDefault(AuroraCollections plugin) {
        if (!CategoriesConfig.getFile(plugin).exists()) {
            plugin.saveResource("categories.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            HashMap<String, String> current = new HashMap<String, String>();
            HashMap<String, List> comments = new HashMap<String, List>();
            List mainComments = yaml.getComments("categories");
            for (String key : yaml.getConfigurationSection("categories").getKeys(false)) {
                current.put(key, yaml.getString("categories." + key, ""));
                comments.put(key, yaml.getComments("categories." + key));
            }
            yaml.set("categories", null);
            yaml.set("config-version", (Object)1);
            ConfigurationSection categories = yaml.createSection("categories");
            yaml.setComments("categories", mainComments);
            for (Map.Entry entry : current.entrySet()) {
                ConfigurationSection category = categories.createSection((String)entry.getKey());
                category.set("name", entry.getValue());
                yaml.setComments("categories." + (String)entry.getKey(), (List)comments.get(entry.getKey()));
            }
        });
    }

    public Map<String, CategoryConfig> getCategories() {
        return this.categories;
    }

    public static class LevelConfig {
        private Double percentage;
        private Map<String, ItemConfig> item;
        private ConfigurationSection rewards;

        public Double getPercentage() {
            return this.percentage;
        }

        public Map<String, ItemConfig> getItem() {
            return this.item;
        }

        public ConfigurationSection getRewards() {
            return this.rewards;
        }
    }

    public static class CategoryConfig {
        private String name;
        private String permission;
        private Map<String, LevelConfig> levels;

        public String getName() {
            return this.name;
        }

        public String getPermission() {
            return this.permission;
        }

        public Map<String, LevelConfig> getLevels() {
            return this.levels;
        }
    }
}

