/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.decorators.IgnoreField;
import gg.auroramc.aurora.api.config.premade.ConcreteMatcherConfig;
import gg.auroramc.aurora.api.config.premade.IntervalMatcherConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.item.TypeId;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;

public class CollectionConfig
extends AuroraConfig {
    private Set<String> triggers;
    private Set<String> types;
    private String name;
    private String menuTitle;
    private String permission;
    private List<Integer> requirements;
    private Boolean useGlobalLevelMatchers = false;
    private Map<String, IntervalMatcherConfig> levelMatchers;
    private Map<String, ConcreteMatcherConfig> customLevels;
    private ItemConfig menuItem;
    private Map<String, ItemConfig> customMenuItems;
    private List<Multiplier> multipliers = new ArrayList<Multiplier>();
    @IgnoreField
    private Set<TypeId> parsedTypes;
    @IgnoreField
    private Set<String> parsedTriggers;
    @IgnoreField
    private List<ParsedMultiplier> parsedMultipliers;

    public CollectionConfig(File file) {
        super(file);
    }

    public void load() {
        super.load();
        this.parsedTypes = this.types.stream().map(TypeId::fromDefault).collect(Collectors.toSet());
        this.parsedTriggers = this.triggers.stream().map(String::toUpperCase).collect(Collectors.toSet());
        this.parsedMultipliers = this.multipliers.stream().map(ParsedMultiplier::new).toList();
    }

    public Set<String> getTriggers() {
        return this.triggers;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public String getName() {
        return this.name;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<Integer> getRequirements() {
        return this.requirements;
    }

    public Boolean getUseGlobalLevelMatchers() {
        return this.useGlobalLevelMatchers;
    }

    public Map<String, IntervalMatcherConfig> getLevelMatchers() {
        return this.levelMatchers;
    }

    public Map<String, ConcreteMatcherConfig> getCustomLevels() {
        return this.customLevels;
    }

    public ItemConfig getMenuItem() {
        return this.menuItem;
    }

    public Map<String, ItemConfig> getCustomMenuItems() {
        return this.customMenuItems;
    }

    public List<Multiplier> getMultipliers() {
        return this.multipliers;
    }

    public Set<TypeId> getParsedTypes() {
        return this.parsedTypes;
    }

    public Set<String> getParsedTriggers() {
        return this.parsedTriggers;
    }

    public List<ParsedMultiplier> getParsedMultipliers() {
        return this.parsedMultipliers;
    }

    public static final class ParsedMultiplier {
        private final Set<String> triggers;
        private final Set<TypeId> types;
        private final Integer value;

        public ParsedMultiplier(Multiplier multiplier) {
            this.triggers = multiplier.getTriggers().stream().map(String::toUpperCase).collect(Collectors.toSet());
            this.types = multiplier.getTypes().stream().map(TypeId::fromDefault).collect(Collectors.toSet());
            this.value = multiplier.getValue();
        }

        public Set<String> getTriggers() {
            return this.triggers;
        }

        public Set<TypeId> getTypes() {
            return this.types;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static final class Multiplier {
        private List<String> triggers = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();
        private Integer value = 1;

        public List<String> getTriggers() {
            return this.triggers;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static final class CustomLevel {
        private ConfigurationSection rewards;

        public ConfigurationSection getRewards() {
            return this.rewards;
        }
    }
}

