/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.IntervalMatcherConfig;
import gg.auroramc.collections.AuroraCollections;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config
extends AuroraConfig {
    private Boolean debug = false;
    private String language = "en";
    private CommandAliasConfig commandAliases;
    private Map<String, IntervalMatcherConfig> globalLevelMatchers;
    private GenericSound levelUpSound;
    private GenericSound discoverSound;
    private GenericMessage levelUpMessage;
    private GenericMessage discoverMessage;
    private GenericMessage categoryLevelUpMessage;
    private Map<String, DisplayComponent> displayComponents;
    private LeaderboardConfig leaderboard;
    private Boolean preventCreativeMode = false;
    private Boolean limitProgressToMaxRequirement = false;

    public Config(AuroraCollections plugin) {
        super(Config.getFile(plugin));
    }

    public static File getFile(AuroraCollections plugin) {
        return new File(plugin.getDataFolder(), "config.yml");
    }

    public static void saveDefault(AuroraCollections plugin) {
        if (!Config.getFile(plugin).exists()) {
            plugin.saveResource("config.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("config-version", null);
            yaml.set("category-level-up-message.enabled", (Object)true);
            yaml.set("category-level-up-message.message", List.of("&3&m----------------------------------------&r", " ", "  &f&l{category_name} milestone reached &6&l{percent}%&r", " ", "component:rewards", " ", "&3&m----------------------------------------"));
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("level-up-message.open-menu-when-clicked", (Object)true);
            yaml.set("category-level-up-message.open-menu-when-clicked", (Object)true);
            yaml.set("command-aliases.progression", List.of("progression"));
            yaml.set("config-version", (Object)2);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("discover-message.enabled", (Object)false);
            yaml.set("discover-message.open-menu-when-clicked", (Object)true);
            yaml.set("discover-message.message", List.of("&3&m----------------------------------------&r", " ", "  &f&l{collection_name} collection discovered&r", " ", "&3&m----------------------------------------"));
            yaml.set("discover-sound.enabled", (Object)false);
            yaml.set("discover-sound.sound", (Object)"ENTITY_PLAYER_LEVELUP");
            yaml.set("discover-sound.volume", (Object)1);
            yaml.set("discover-sound.pitch", (Object)1);
            yaml.set("config-version", (Object)3);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("level-up-sound.sound", (Object)"entity.player.levelup");
            yaml.set("discover-sound.sound", (Object)"entity.player.levelup");
            yaml.set("config-version", (Object)4);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("limit-progress-to-max-requirement", (Object)false);
            yaml.setComments("limit-progress-to-max-requirement", List.of("Prevents players from progressing in collections if they are already at max level", "This is not recommended unless you are not finished with your level (beta testing server etc.)"));
            yaml.set("config-version", (Object)5);
        });
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public String getLanguage() {
        return this.language;
    }

    public CommandAliasConfig getCommandAliases() {
        return this.commandAliases;
    }

    public Map<String, IntervalMatcherConfig> getGlobalLevelMatchers() {
        return this.globalLevelMatchers;
    }

    public GenericSound getLevelUpSound() {
        return this.levelUpSound;
    }

    public GenericSound getDiscoverSound() {
        return this.discoverSound;
    }

    public GenericMessage getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public GenericMessage getDiscoverMessage() {
        return this.discoverMessage;
    }

    public GenericMessage getCategoryLevelUpMessage() {
        return this.categoryLevelUpMessage;
    }

    public Map<String, DisplayComponent> getDisplayComponents() {
        return this.displayComponents;
    }

    public LeaderboardConfig getLeaderboard() {
        return this.leaderboard;
    }

    public Boolean getPreventCreativeMode() {
        return this.preventCreativeMode;
    }

    public Boolean getLimitProgressToMaxRequirement() {
        return this.limitProgressToMaxRequirement;
    }

    public static final class CommandAliasConfig {
        private List<String> collections = List.of("collections");
        private List<String> progression = List.of("progression");

        public List<String> getCollections() {
            return this.collections;
        }

        public List<String> getProgression() {
            return this.progression;
        }
    }

    public static final class GenericSound {
        private Boolean enabled;
        private String sound;
        private Float volume;
        private Float pitch;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getSound() {
            return this.sound;
        }

        public Float getVolume() {
            return this.volume;
        }

        public Float getPitch() {
            return this.pitch;
        }
    }

    public static final class GenericMessage {
        private Boolean enabled;
        private Boolean openMenuWhenClicked = false;
        private List<String> message;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Boolean getOpenMenuWhenClicked() {
            return this.openMenuWhenClicked;
        }

        public List<String> getMessage() {
            return this.message;
        }

        public String toString() {
            return "Config.GenericMessage(enabled=" + this.getEnabled() + ", openMenuWhenClicked=" + this.getOpenMenuWhenClicked() + ", message=" + String.valueOf(this.getMessage()) + ")";
        }
    }

    public static final class LeaderboardConfig {
        private Integer cacheSize = 10;
        private Integer minItemsCollected = 10;

        public Integer getCacheSize() {
            return this.cacheSize;
        }

        public Integer getMinItemsCollected() {
            return this.minItemsCollected;
        }
    }

    public static final class DisplayComponent {
        private String title;
        private String line;

        public String getTitle() {
            return this.title;
        }

        public String getLine() {
            return this.line;
        }
    }
}

