/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config;

import com.google.common.collect.Maps;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.config.CategoriesConfig;
import gg.auroramc.collections.config.CollectionConfig;
import gg.auroramc.collections.config.Config;
import gg.auroramc.collections.config.MessageConfig;
import gg.auroramc.collections.config.MetaConfig;
import gg.auroramc.collections.config.menu.CategoriesMenuConfig;
import gg.auroramc.collections.config.menu.CategoryRewardsMenuConfig;
import gg.auroramc.collections.config.menu.CollectionListMenuConfig;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class ConfigManager {
    private final AuroraCollections plugin;
    private Config config;
    private MetaConfig metaConfig;
    private MessageConfig messageConfig;
    private CategoriesConfig categoriesConfig;
    private CategoriesMenuConfig categoriesMenuConfig;
    private CollectionListMenuConfig collectionListMenuConfig;
    private CollectionMenuConfig collectionMenuConfig;
    private CategoryRewardsMenuConfig categoryRewardsMenuConfig;
    private final Map<String, Map<String, CollectionConfig>> collections = Maps.newConcurrentMap();

    public ConfigManager(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        boolean saveDefaultCollections = !Config.getFile(this.plugin).exists();
        Config.saveDefault(this.plugin);
        this.config = new Config(this.plugin);
        this.config.load();
        MetaConfig.saveDefault(this.plugin);
        this.metaConfig = new MetaConfig(this.plugin);
        this.metaConfig.load();
        MessageConfig.saveDefault(this.plugin, this.config.getLanguage());
        this.messageConfig = new MessageConfig(this.plugin, this.config.getLanguage());
        this.messageConfig.load();
        CategoriesConfig.saveDefault(this.plugin);
        this.categoriesConfig = new CategoriesConfig(this.plugin);
        this.categoriesConfig.load();
        CategoriesMenuConfig.saveDefault(this.plugin);
        this.categoriesMenuConfig = new CategoriesMenuConfig(this.plugin);
        this.categoriesMenuConfig.load();
        CollectionListMenuConfig.saveDefault(this.plugin);
        this.collectionListMenuConfig = new CollectionListMenuConfig(this.plugin);
        this.collectionListMenuConfig.load();
        CollectionMenuConfig.saveDefault(this.plugin);
        this.collectionMenuConfig = new CollectionMenuConfig(this.plugin);
        this.collectionMenuConfig.load();
        CategoryRewardsMenuConfig.saveDefault(this.plugin);
        this.categoryRewardsMenuConfig = new CategoryRewardsMenuConfig(this.plugin);
        this.categoryRewardsMenuConfig.load();
        if (saveDefaultCollections) {
            this.saveDefaultCollections();
        }
        this.reloadCollections();
    }

    private void reloadCollections() {
        this.collections.clear();
        Path collectionsDir = this.plugin.getDataFolder().toPath().resolve("collections");
        if (!Files.exists(collectionsDir, new LinkOption[0]) || !Files.isDirectory(collectionsDir, new LinkOption[0])) {
            return;
        }
        for (File dir : collectionsDir.toFile().listFiles()) {
            if (!dir.isDirectory()) {
                AuroraCollections.logger().warning("File " + dir.getName() + " is in the collections directory, but should be in a category subdirectory");
                continue;
            }
            if (this.categoriesConfig.getCategories().keySet().contains(dir.getName())) continue;
            AuroraCollections.logger().warning("Category " + dir.getName() + " does not exist in categories.yml");
        }
        Pattern validIdPattern = Pattern.compile("^[a-zA-Z0-9_-]+$");
        for (String dir : this.categoriesConfig.getCategories().keySet()) {
            Path categoryDir = collectionsDir.resolve(dir);
            if (!Files.exists(categoryDir, new LinkOption[0])) continue;
            if (!validIdPattern.matcher(dir).matches()) {
                AuroraCollections.logger().severe("Category ID: '" + dir + "' doesn't match the required format ^[a-zA-Z0-9_-]+$. Use only english alphabet, numbers, underscores and hyphens. Category will be loaded, but you may experience issues.");
            }
            try {
                Stream<Path> paths = Files.list(categoryDir);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".yml")).forEach(path -> {
                        String fileName = path.getFileName().toString().replace(".yml", "");
                        if (fileName.contains(".")) {
                            AuroraCollections.logger().severe("ID: '" + fileName + "' contains a dot/period (.), which is not allowed. Skipping.");
                            return;
                        }
                        if (!validIdPattern.matcher(fileName).matches()) {
                            AuroraCollections.logger().warning("ID: '" + fileName + "' doesn't match the required format ^[a-zA-Z0-9_-]+$. Use only english alphabet, numbers, underscores and hyphens. Collection will be loaded, but you may experience issues.");
                        }
                        CollectionConfig collectionConfig = new CollectionConfig(path.toFile());
                        collectionConfig.load();
                        this.collections.computeIfAbsent(dir, k -> Maps.newConcurrentMap()).computeIfAbsent(fileName, k -> collectionConfig);
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                AuroraCollections.logger().warning("Failed to load collections for category: " + dir + " error: " + e.getMessage());
            }
        }
    }

    private void saveDefaultCollections() {
        Path jarPath = Path.of(((Object)((Object)this.plugin)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        Path dataFolder = this.plugin.getDataFolder().toPath();
        try (JarFile jar = new JarFile(jarPath.toFile());){
            jar.stream().filter(entry -> entry.getName().startsWith("collections/") && entry.getName().endsWith(".yml")).forEach(entry -> {
                Path outFile = dataFolder.resolve(entry.getName());
                Path parentDir = outFile.getParent();
                if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(parentDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try (InputStream is = jar.getInputStream((ZipEntry)entry);){
                    Files.copy(is, outFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AuroraCollections getPlugin() {
        return this.plugin;
    }

    public Config getConfig() {
        return this.config;
    }

    public MetaConfig getMetaConfig() {
        return this.metaConfig;
    }

    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    public CategoriesConfig getCategoriesConfig() {
        return this.categoriesConfig;
    }

    public CategoriesMenuConfig getCategoriesMenuConfig() {
        return this.categoriesMenuConfig;
    }

    public CollectionListMenuConfig getCollectionListMenuConfig() {
        return this.collectionListMenuConfig;
    }

    public CollectionMenuConfig getCollectionMenuConfig() {
        return this.collectionMenuConfig;
    }

    public CategoryRewardsMenuConfig getCategoryRewardsMenuConfig() {
        return this.categoryRewardsMenuConfig;
    }

    public Map<String, Map<String, CollectionConfig>> getCollections() {
        return this.collections;
    }
}

