/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config.menu;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class CategoriesMenuConfig
extends AuroraConfig {
    private String title;
    private FillerItem filler;
    private Map<String, ItemConfig> items;
    private Map<String, ItemConfig> customItems;
    private Integer rows = 6;
    private CollectionMenuConfig.ProgressBar progressBar;

    public CategoriesMenuConfig(AuroraCollections plugin) {
        super(CategoriesMenuConfig.getFile(plugin));
    }

    public static File getFile(AuroraCollections plugin) {
        return new File(String.valueOf(plugin.getDataFolder()) + "/menus", "categories.yml");
    }

    public static void saveDefault(AuroraCollections plugin) {
        if (!CategoriesMenuConfig.getFile(plugin).exists()) {
            plugin.saveResource("menus/categories.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("config-version", null);
            yaml.set("progress-bar.length", (Object)10);
            yaml.set("progress-bar.filled-character", (Object)"&a&l\u25a0");
            yaml.set("progress-bar.unfilled-character", (Object)"&7&l\u25a0");
            yaml.set("config-version", (Object)1);
        });
    }

    public String getTitle() {
        return this.title;
    }

    public FillerItem getFiller() {
        return this.filler;
    }

    public Map<String, ItemConfig> getItems() {
        return this.items;
    }

    public Map<String, ItemConfig> getCustomItems() {
        return this.customItems;
    }

    public Integer getRows() {
        return this.rows;
    }

    public CollectionMenuConfig.ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public static final class FillerItem {
        private Boolean enabled;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }
}

