/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config.menu;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.collections.AuroraCollections;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class CollectionListMenuConfig
extends AuroraConfig {
    private String title;
    private Map<String, ItemConfig> customItems;
    private List<Integer> displayArea;
    private Items items;
    private Integer rows = 6;
    private CategoryIcon categoryIcon;
    private SecretCollectionDisplay secretCollectionDisplay = new SecretCollectionDisplay();

    public CollectionListMenuConfig(AuroraCollections plugin) {
        super(CollectionListMenuConfig.getFile(plugin));
    }

    public static File getFile(AuroraCollections plugin) {
        return new File(String.valueOf(plugin.getDataFolder()) + "/menus", "collection_list.yml");
    }

    public static void saveDefault(AuroraCollections plugin) {
        if (!CollectionListMenuConfig.getFile(plugin).exists()) {
            plugin.saveResource("menus/collection_list.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("category-icon.enabled", (Object)true);
            yaml.set("category-icon.item.slot", (Object)4);
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("secret-collection-display.enabled", (Object)false);
            yaml.set("secret-collection-display.item.material", (Object)"gray_dye");
            yaml.set("secret-collection-display.item.name", (Object)"&c{collection_name}");
            yaml.set("secret-collection-display.item.lore", List.of("&7You haven't discovered this", "&7Collection yet!"));
            yaml.set("config-version", (Object)2);
        });
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, ItemConfig> getCustomItems() {
        return this.customItems;
    }

    public List<Integer> getDisplayArea() {
        return this.displayArea;
    }

    public Items getItems() {
        return this.items;
    }

    public Integer getRows() {
        return this.rows;
    }

    public CategoryIcon getCategoryIcon() {
        return this.categoryIcon;
    }

    public SecretCollectionDisplay getSecretCollectionDisplay() {
        return this.secretCollectionDisplay;
    }

    public static final class SecretCollectionDisplay {
        private Boolean enabled = false;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }

    public static final class Items {
        private FillerItem filler;
        private ItemConfig previousPage;
        private ItemConfig currentPage;
        private ItemConfig nextPage;
        private ItemConfig back;

        public FillerItem getFiller() {
            return this.filler;
        }

        public ItemConfig getPreviousPage() {
            return this.previousPage;
        }

        public ItemConfig getCurrentPage() {
            return this.currentPage;
        }

        public ItemConfig getNextPage() {
            return this.nextPage;
        }

        public ItemConfig getBack() {
            return this.back;
        }
    }

    public static final class CategoryIcon {
        private Boolean enabled;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }

    public static final class FillerItem {
        private Boolean enabled;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }
}

