/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.config.menu;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.collections.AuroraCollections;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class CollectionMenuConfig
extends AuroraConfig {
    private String title;
    private ProgressBar progressBar;
    private Map<String, ItemConfig> customItems;
    private Map<String, DisplayComponent> displayComponents;
    private List<Integer> displayArea;
    private Items items;
    private Boolean allowItemAmounts = false;
    private Boolean forceRomanNumerals = false;
    private ItemTemplate collectionMenuTemplate;
    private Integer rows = 6;

    public CollectionMenuConfig(AuroraCollections plugin) {
        super(CollectionMenuConfig.getFile(plugin));
    }

    public static File getFile(AuroraCollections plugin) {
        return new File(String.valueOf(plugin.getDataFolder()) + "/menus", "collection.yml");
    }

    public static void saveDefault(AuroraCollections plugin) {
        if (!CollectionMenuConfig.getFile(plugin).exists()) {
            plugin.saveResource("menus/collection.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("config-version", null);
            yaml.set("items.next-level", (Object)yaml.getConfigurationSection("items.locked-level"));
            yaml.set("config-version", (Object)1);
        });
    }

    public String getTitle() {
        return this.title;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Map<String, ItemConfig> getCustomItems() {
        return this.customItems;
    }

    public Map<String, DisplayComponent> getDisplayComponents() {
        return this.displayComponents;
    }

    public List<Integer> getDisplayArea() {
        return this.displayArea;
    }

    public Items getItems() {
        return this.items;
    }

    public Boolean getAllowItemAmounts() {
        return this.allowItemAmounts;
    }

    public Boolean getForceRomanNumerals() {
        return this.forceRomanNumerals;
    }

    public ItemTemplate getCollectionMenuTemplate() {
        return this.collectionMenuTemplate;
    }

    public Integer getRows() {
        return this.rows;
    }

    public static final class ProgressBar {
        private Integer length = 20;
        private String filledCharacter = "";
        private String unfilledCharacter = "";

        public Integer getLength() {
            return this.length;
        }

        public String getFilledCharacter() {
            return this.filledCharacter;
        }

        public String getUnfilledCharacter() {
            return this.unfilledCharacter;
        }
    }

    public static final class Items {
        private FillerItem filler;
        private ItemConfig previousPage;
        private ItemConfig currentPage;
        private ItemConfig nextPage;
        private ItemConfig completedLevel;
        private ItemConfig lockedLevel;
        private ItemConfig nextLevel;
        private ItemConfig back;

        public FillerItem getFiller() {
            return this.filler;
        }

        public ItemConfig getPreviousPage() {
            return this.previousPage;
        }

        public ItemConfig getCurrentPage() {
            return this.currentPage;
        }

        public ItemConfig getNextPage() {
            return this.nextPage;
        }

        public ItemConfig getCompletedLevel() {
            return this.completedLevel;
        }

        public ItemConfig getLockedLevel() {
            return this.lockedLevel;
        }

        public ItemConfig getNextLevel() {
            return this.nextLevel;
        }

        public ItemConfig getBack() {
            return this.back;
        }
    }

    public static final class ItemTemplate {
        private ItemConfig item;
        private Boolean enabled = true;

        public ItemConfig getItem() {
            return this.item;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }
    }

    public static final class FillerItem {
        private Boolean enabled;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }

    public static final class DisplayComponent {
        private String title;
        private String line;

        public String getTitle() {
            return this.title;
        }

        public String getLine() {
            return this.line;
        }
    }
}

