/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.auraskills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.user.SkillsUser;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.hooks.auraskills.AuraSkillsStatReward;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuraSkillsCorrector
implements RewardCorrector {
    private final AuroraCollections plugin;
    private final Set<UUID> toLoad = Sets.newConcurrentHashSet();

    public AuraSkillsCorrector(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        if (AuraSkillsApi.get().getUser(player.getUniqueId()).isLoaded()) {
            this.correctRewardsWhenLoaded(player, true);
        } else {
            this.toLoad.add(player.getUniqueId());
        }
    }

    public void correctRewardsWhenLoaded(Player player, boolean force) {
        if (!force && !this.toLoad.contains(player.getUniqueId())) {
            return;
        }
        this.toLoad.remove(player.getUniqueId());
        CollectionManager manager = this.plugin.getCollectionManager();
        HashMap statMap = Maps.newHashMap();
        for (Stat stat : AuraSkillsApi.get().getGlobalRegistry().getStats()) {
            statMap.put(stat, 0.0);
        }
        for (Collection collection : manager.getAllCollections()) {
            int level = collection.getPlayerLevel(player);
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = collection.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = collection.getPlaceholders(player, i);
                for (Reward reward : matcher.computeRewards(i)) {
                    if (!(reward instanceof AuraSkillsStatReward)) continue;
                    AuraSkillsStatReward statReward = (AuraSkillsStatReward)reward;
                    statMap.merge(statReward.getStat(), statReward.getValue(placeholders), Double::sum);
                }
            }
        }
        for (Category category : manager.getCategories()) {
            if (!category.isLevelingEnabled()) continue;
            List<Reward> rewards = category.getRewards(manager.getCategoryLevel(category.getId(), player), manager.getMaxCategoryLevel(category.getId()));
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{category_name}", (String)category.getConfig().getName()), Placeholder.of((String)"{category_id}", (String)category.getId()));
            for (Reward reward : rewards) {
                if (!(reward instanceof AuraSkillsStatReward)) continue;
                AuraSkillsStatReward statReward = (AuraSkillsStatReward)reward;
                statMap.merge(statReward.getStat(), statReward.getValue(placeholders), Double::sum);
            }
        }
        player.getScheduler().run((Plugin)this.plugin, task -> {
            for (Map.Entry entry : statMap.entrySet()) {
                String statKey = AuraSkillsStatReward.getAURA_SKILLS_STAT() + ((Stat)entry.getKey()).getId().toString();
                SkillsUser user = AuraSkillsApi.get().getUser(player.getUniqueId());
                StatModifier oldModifier = user.getStatModifier(statKey);
                if (oldModifier == null) {
                    if (!((Double)entry.getValue() > 0.0)) continue;
                    user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
                    continue;
                }
                if ((Double)entry.getValue() <= 0.0) {
                    user.removeStatModifier(statKey);
                    continue;
                }
                if (((Double)entry.getValue()).doubleValue() == oldModifier.value()) continue;
                user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
            }
        }, null);
    }
}

