/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.auraskills;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.hooks.auraskills.AuraSkillsHook;
import gg.auroramc.collections.listener.BlockBreakListener;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class AuraSkillsListener
implements Listener {
    private final AuroraCollections plugin;
    private final AuraSkillsHook hook;

    public AuraSkillsListener(AuroraCollections plugin, AuraSkillsHook hook) {
        this.plugin = plugin;
        this.hook = hook;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExtraDrop(LootDropEvent e) {
        ItemStack item = e.getItem();
        CollectionManager manager = this.plugin.getCollectionManager();
        TypeId typeId = TypeId.from((Material)item.getType());
        if (BlockBreakListener.specialCrops.contains(item.getType()) && typeId.namespace().equals("minecraft")) {
            manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "HARVEST");
            return;
        }
        switch (e.getCause()) {
            case FARMING_LUCK: 
            case FARMING_OTHER_LOOT: {
                manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "HARVEST");
                break;
            }
            case FISHING_LUCK: 
            case TREASURE_HUNTER: 
            case EPIC_CATCH: 
            case FISHING_OTHER_LOOT: {
                manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "FISH");
                break;
            }
            case FORAGING_LUCK: 
            case FORAGING_OTHER_LOOT: 
            case MINING_LUCK: 
            case EXCAVATION_OTHER_LOOT: 
            case LUCKY_SPADES: 
            case MINING_OTHER_LOOT: 
            case EXCAVATION_LUCK: 
            case METAL_DETECTOR: {
                manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "BLOCK_LOOT");
                break;
            }
            case MOB_LOOT_TABLE: {
                manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "ENTITY_LOOT");
                break;
            }
            case LUCK_DOUBLE_DROP: {
                manager.progressCollections(e.getPlayer(), typeId, item.getAmount(), "HARVEST", "FISH", "BLOCK_LOOT", "ENTITY_LOOT");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUserDataLoad(UserLoadEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getUser().getUuid());
        if (player == null) {
            return;
        }
        CompletableFuture.runAsync(() -> this.hook.getCorrector().correctRewardsWhenLoaded(player, false));
    }
}

