/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.customfishing;

import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.config.CollectionConfig;
import gg.auroramc.collections.hooks.Hook;
import gg.auroramc.collections.hooks.customfishing.listener.CustomFishingListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.momirealms.customfishing.api.BukkitCustomFishingPlugin;
import net.momirealms.customfishing.api.mechanic.loot.Loot;
import net.momirealms.customfishing.api.mechanic.loot.LootType;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CustomFishingHook
implements Hook {
    @Override
    public void hook(AuroraCollections plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new CustomFishingListener(plugin), (Plugin)plugin);
        if (!plugin.getConfigManager().getMetaConfig().isCustomFishingCollectionsSaved()) {
            this.generateDefaultCollections(plugin);
            plugin.getConfigManager().getMetaConfig().setCustomFishingCollectionsSaved(true);
            plugin.getConfigManager().getMetaConfig().saveChanges();
            AuroraCollections.logger().info("Generated default fishing collections for CustomFishing");
        }
        AuroraCollections.logger().info("Hooked into CustomFishing for fishing collection with namespace 'customfishing'");
    }

    private void generateDefaultCollections(AuroraCollections plugin) {
        for (Loot loot : BukkitCustomFishingPlugin.getInstance().getLootManager().getRegisteredLoots()) {
            File file;
            if (loot.type() != LootType.ITEM || Arrays.stream(loot.lootGroup()).noneMatch(s -> s.contains("river") || s.contains("ocean")) || loot.id().equals("vanilla") || (file = new File(plugin.getDataFolder(), "collections/fishing/0005_cf_" + loot.id() + ".yml")).exists()) continue;
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.set("triggers", List.of("fish"));
            yaml.set("types", List.of("customfishing:" + loot.id()));
            yaml.set("name", (Object)loot.nick());
            yaml.set("menu-item.material", (Object)("customfishing:" + loot.id()));
            yaml.set("requirements", List.of(Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(250), Integer.valueOf(1000), Integer.valueOf(2500), Integer.valueOf(5000), Integer.valueOf(10000)));
            yaml.set("use-global-level-matchers", (Object)true);
            try {
                file.createNewFile();
                yaml.save(file);
                CollectionConfig config = new CollectionConfig(file);
                config.load();
                plugin.getConfigManager().getCollections().get("fishing").put("0005_cf_" + loot.id(), config);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

