/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.luckperms;

import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.PermissionReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import java.util.ArrayList;
import java.util.List;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.util.Tristate;
import org.bukkit.entity.Player;

public class PermissionCorrector
implements RewardCorrector {
    private final AuroraCollections plugin;

    public PermissionCorrector(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        CollectionManager manager = this.plugin.getCollectionManager();
        ArrayList<Node> nodesToAdd = new ArrayList<Node>();
        for (Collection collection : manager.getAllCollections()) {
            int level = collection.getPlayerLevel(player);
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = collection.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = collection.getPlaceholders(player, i);
                for (Reward reward : matcher.computeRewards(i)) {
                    if (!(reward instanceof PermissionReward)) continue;
                    PermissionReward permissionReward = (PermissionReward)reward;
                    nodesToAdd.addAll(this.getNodes(player, permissionReward, placeholders));
                }
            }
        }
        for (Category category : manager.getCategories()) {
            if (!category.isLevelingEnabled()) continue;
            List<Reward> rewards = category.getRewards(manager.getCategoryLevel(category.getId(), player), manager.getMaxCategoryLevel(category.getId()));
            List<Placeholder<?>> placeholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{category_name}", (String)category.getConfig().getName()), Placeholder.of((String)"{category_id}", (String)category.getId()));
            for (Reward reward : rewards) {
                if (!(reward instanceof PermissionReward)) continue;
                PermissionReward permissionReward = (PermissionReward)reward;
                nodesToAdd.addAll(this.getNodes(player, permissionReward, placeholders));
            }
        }
        if (nodesToAdd.isEmpty()) {
            return;
        }
        User user = LuckPermsProvider.get().getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            AuroraCollections.logger().severe("User " + player.getName() + " is not loaded in LuckPerms, failed to correct permission rewards!");
            return;
        }
        int addedNodes = 0;
        for (Node node : nodesToAdd) {
            Tristate hasPermission = user.data().contains(node, NodeEqualityPredicate.EXACT);
            if (!hasPermission.equals((Object)Tristate.UNDEFINED)) continue;
            AuroraCollections.logger().debug("Permission " + node.getKey() + " is undefined for player " + player.getName());
            user.data().add(node);
            ++addedNodes;
        }
        if (addedNodes > 0) {
            LuckPermsProvider.get().getUserManager().saveUser(user);
            AuroraCollections.logger().debug("Added " + addedNodes + " permission nodes to player " + player.getName());
        }
    }

    private List<Node> getNodes(Player player, PermissionReward permissionReward, List<Placeholder<?>> placeholders) {
        if (permissionReward.getPermissions() == null || permissionReward.getPermissions().isEmpty()) {
            return List.of();
        }
        return permissionReward.buildNodes(player, placeholders);
    }
}

