/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.mmoitems;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.hooks.Hook;
import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmoitems.api.event.ItemDropEvent;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class MMOItemsHook
implements Hook,
Listener {
    private AuroraCollections plugin;

    @Override
    public void hook(AuroraCollections plugin) {
        this.plugin = plugin;
        AuroraCollections.logger().info("Hooked into MMOItems for block loot collection with namespace 'mmoitems'.");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCustomBlockBreak(ItemDropEvent event) {
        if (event.getCause() != ItemDropEvent.DropCause.CUSTOM_BLOCK) {
            return;
        }
        LivingEntity livingEntity = event.getWhoDropped();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (AuroraAPI.getRegionManager().isPlacedBlock(event.getMinedBlock())) {
            return;
        }
        for (ItemStack drop : event.getDrops()) {
            NBTItem nbtItem = NBTItem.get((ItemStack)drop);
            TypeId typeId = nbtItem.hasType() ? new TypeId("mmoitems", nbtItem.getType() + ":" + nbtItem.getString("MMOITEMS_ITEM_ID")) : TypeId.from((Material)drop.getType());
            this.plugin.getCollectionManager().progressCollections(player, typeId, drop.getAmount(), "BLOCK_LOOT");
        }
    }
}

