/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.mmolib;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.hooks.mmolib.MMOStatReward;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MMOStatCorrector
implements RewardCorrector {
    private final AuroraCollections plugin;

    public MMOStatCorrector(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        CollectionManager manager = this.plugin.getCollectionManager();
        MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)player);
        StatMap stats = playerData.getStatMap();
        HashMap statMap = Maps.newHashMap();
        for (Collection collection : manager.getAllCollections()) {
            int level = collection.getPlayerLevel(player);
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = collection.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = collection.getPlaceholders(player, i);
                for (Reward reward : matcher.computeRewards(i)) {
                    MMOStatReward statReward;
                    if (!(reward instanceof MMOStatReward) || !(statReward = (MMOStatReward)reward).isValid()) continue;
                    String key = NamespacedId.of((String)MMOStatReward.getMMO_STAT(), (String)statReward.getStat()).toString();
                    StatModifier current = statReward.getCurrentModifier(key, stats);
                    UUID uuid = current != null ? current.getUniqueId() : UUID.randomUUID();
                    statMap.merge(statReward.getStat(), new MMOStat(statReward.getModifierType(), statReward.getValue(placeholders), key, uuid), (a, b) -> new MMOStat(statReward.getModifierType(), a.value() + b.value(), a.key(), a.uuid()));
                }
            }
        }
        for (Category category : manager.getCategories()) {
            if (!category.isLevelingEnabled()) continue;
            List<Reward> rewards = category.getRewards(manager.getCategoryLevel(category.getId(), player), manager.getMaxCategoryLevel(category.getId()));
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{category_name}", (String)category.getConfig().getName()), Placeholder.of((String)"{category_id}", (String)category.getId()));
            for (Reward reward : rewards) {
                MMOStatReward statReward;
                if (!(reward instanceof MMOStatReward) || !(statReward = (MMOStatReward)reward).isValid()) continue;
                String key = NamespacedId.of((String)MMOStatReward.getMMO_STAT(), (String)statReward.getStat()).toString();
                StatModifier current = statReward.getCurrentModifier(key, stats);
                UUID uuid = current != null ? current.getUniqueId() : UUID.randomUUID();
                statMap.merge(statReward.getStat(), new MMOStat(statReward.getModifierType(), statReward.getValue(placeholders), key, uuid), (a, b) -> new MMOStat(statReward.getModifierType(), a.value() + b.value(), a.key(), a.uuid()));
            }
        }
        player.getScheduler().runDelayed((Plugin)this.plugin, task -> {
            for (Map.Entry entry : statMap.entrySet()) {
                String statType = (String)entry.getKey();
                MMOStat s = (MMOStat)entry.getValue();
                new StatModifier(s.uuid, s.key, statType, s.value, s.modifierType, EquipmentSlot.OTHER, ModifierSource.OTHER).register(playerData);
            }
        }, null, 3L);
    }

    public record MMOStat(ModifierType modifierType, double value, String key, UUID uuid) {
    }
}

