/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.mythic.reward;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.hooks.mythic.reward.MythicStatReward;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class MythicStatCorrector
implements RewardCorrector {
    private final AuroraCollections plugin;

    public MythicStatCorrector(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        CollectionManager manager = this.plugin.getCollectionManager();
        MythicBukkit mythic = MythicBukkit.inst();
        StatRegistry registry = ((PlayerData)mythic.getPlayerManager().getProfile(player)).getStatRegistry();
        HashMap statMap = Maps.newHashMap();
        mythic.getStatManager().getStats().values().forEach(statType -> {
            if (!statType.isEnabled()) {
                return;
            }
            registry.removeValue(statType, MythicStatReward.getSource());
        });
        for (Collection collection : manager.getAllCollections()) {
            int level = collection.getPlayerLevel(player);
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = collection.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = collection.getPlaceholders(player, i);
                for (Reward reward : matcher.computeRewards(i)) {
                    MythicStatReward statReward;
                    if (!(reward instanceof MythicStatReward) || !(statReward = (MythicStatReward)reward).isValid()) continue;
                    statMap.computeIfAbsent(statReward.getStatType(), key -> Maps.newHashMap()).merge(statReward.getModifierType(), statReward.getValue(placeholders), Double::sum);
                }
            }
        }
        for (Category category : manager.getCategories()) {
            if (!category.isLevelingEnabled()) continue;
            List<Reward> rewards = category.getRewards(manager.getCategoryLevel(category.getId(), player), manager.getMaxCategoryLevel(category.getId()));
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{category_name}", (String)category.getConfig().getName()), Placeholder.of((String)"{category_id}", (String)category.getId()));
            for (Reward reward : rewards) {
                MythicStatReward statReward;
                if (!(reward instanceof MythicStatReward) || !(statReward = (MythicStatReward)reward).isValid()) continue;
                statMap.computeIfAbsent(statReward.getStatType(), key -> Maps.newHashMap()).merge(statReward.getModifierType(), statReward.getValue(placeholders), Double::sum);
            }
        }
        for (Map.Entry entry : statMap.entrySet()) {
            StatType statType2 = (StatType)entry.getKey();
            for (Map.Entry modifierEntry : ((Map)entry.getValue()).entrySet()) {
                StatModifierType modifierType = (StatModifierType)modifierEntry.getKey();
                Double value = (Double)modifierEntry.getValue();
                AuroraCollections.logger().debug("Adding stat " + statType2.getKey() + " with value " + value + " to player " + player.getName());
                registry.putValue(statType2, MythicStatReward.getSource(), modifierType, value.doubleValue());
            }
        }
    }
}

