/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.hooks.oraxen;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.hooks.Hook;
import io.th0rgal.oraxen.api.events.custom_block.noteblock.OraxenNoteBlockDropLootEvent;
import io.th0rgal.oraxen.api.events.custom_block.stringblock.OraxenStringBlockDropLootEvent;
import io.th0rgal.oraxen.utils.drops.DroppedLoot;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Oraxen2Hook
implements Hook,
Listener {
    private AuroraCollections plugin;

    @Override
    public void hook(AuroraCollections plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        AuroraCollections.logger().info("Hooked into Oraxen 2 for collection progression with namespace 'oraxen'.");
    }

    @EventHandler
    public void onNoteBlockLootDrop(OraxenNoteBlockDropLootEvent e) {
        if (this.invalid(e.getPlayer(), e.getBlock())) {
            return;
        }
        this.handleProgression(e.getPlayer(), e.getLoots());
    }

    @EventHandler
    public void onStringBlockLootDrop(OraxenStringBlockDropLootEvent e) {
        if (this.invalid(e.getPlayer(), e.getBlock())) {
            return;
        }
        this.handleProgression(e.getPlayer(), e.getLoots());
    }

    private boolean invalid(Player player, Block block) {
        return player == null || block == null || AuroraAPI.getRegionManager().isPlacedBlock(block);
    }

    private void handleProgression(Player player, List<DroppedLoot> droppedLootList) {
        for (DroppedLoot droppedLoot : droppedLootList) {
            ItemStack itemStack = droppedLoot.loot().itemStack();
            TypeId typeId = this.plugin.getItemManager().resolveId(itemStack);
            this.plugin.getCollectionManager().progressCollections(player, typeId, droppedLoot.amount(), "BLOCK_LOOT");
        }
    }
}

