/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.libs.acf.lib.expiringmap;

import gg.auroramc.collections.libs.acf.lib.expiringmap.ExpirationPolicy;
import java.util.concurrent.TimeUnit;

public final class ExpiringValue<V> {
    private static final long UNSET_DURATION = -1L;
    private final V value;
    private final ExpirationPolicy expirationPolicy;
    private final long duration;
    private final TimeUnit timeUnit;

    public ExpiringValue(V value) {
        this(value, -1L, null, null);
    }

    public ExpiringValue(V value, ExpirationPolicy expirationPolicy) {
        this(value, -1L, null, expirationPolicy);
    }

    public ExpiringValue(V value, long duration, TimeUnit timeUnit) {
        this(value, duration, timeUnit, null);
        if (timeUnit == null) {
            throw new NullPointerException();
        }
    }

    public ExpiringValue(V value, ExpirationPolicy expirationPolicy, long duration, TimeUnit timeUnit) {
        this(value, duration, timeUnit, expirationPolicy);
        if (timeUnit == null) {
            throw new NullPointerException();
        }
    }

    private ExpiringValue(V value, long duration, TimeUnit timeUnit, ExpirationPolicy expirationPolicy) {
        this.value = value;
        this.expirationPolicy = expirationPolicy;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public V getValue() {
        return this.value;
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ExpiringValue that = (ExpiringValue)o;
        if (this.value != null) {
            if (!this.value.equals(that.value)) {
                return false;
            }
        } else if (that.value != null) return false;
        if (this.expirationPolicy != that.expirationPolicy) return false;
        if (this.duration != that.duration) return false;
        if (this.timeUnit != that.timeUnit) return false;
        return true;
    }

    public String toString() {
        return "ExpiringValue{value=" + this.value + ", expirationPolicy=" + (Object)((Object)this.expirationPolicy) + ", duration=" + this.duration + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }
}

