/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.listener;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.collections.AuroraCollections;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DamageListener
implements Listener {
    private final AuroraCollections plugin;

    public DamageListener(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        LivingEntity livingEntity;
        Player damager = this.getDamager(event);
        Entity victim = event.getEntity();
        if (damager == null) {
            return;
        }
        if (victim instanceof Player) {
            return;
        }
        double damage = event.getFinalDamage();
        if (victim instanceof LivingEntity && damage > (livingEntity = (LivingEntity)victim).getHealth()) {
            damage = livingEntity.getHealth();
        }
        TypeId id = AuroraAPI.getEntityManager().resolveId(victim);
        this.plugin.getCollectionManager().progressCollections(damager, id, (int)Math.floor(damage), "ENTITY_DAMAGE");
    }

    private Player getDamager(EntityDamageByEntityEvent event) {
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        entity = event.getDamager();
        if (entity instanceof Projectile && (projectileSource = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            Player player = (Player)projectileSource;
            return player;
        }
        return null;
    }
}

