/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.listener;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.CollectionManager;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityKillListener
implements Listener {
    private final AuroraCollections plugin;

    public EntityKillListener(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent e) {
        Player killer = e.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        if (e.getEntity() instanceof Player) {
            return;
        }
        List drops = e.getDrops();
        CollectionManager manager = this.plugin.getCollectionManager();
        TypeId mobId = AuroraAPI.getEntityManager().resolveId((Entity)e.getEntity());
        if (mobId.namespace().equals("mythicmobs")) {
            return;
        }
        manager.progressCollections(killer, mobId, 1, "ENTITY_KILL");
        for (ItemStack drop : drops) {
            manager.progressCollections(killer, this.plugin.getItemManager().resolveId(drop), drop.getAmount(), "ENTITY_LOOT");
        }
    }
}

