/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.menu;

import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.config.menu.CategoriesMenuConfig;
import gg.auroramc.collections.menu.CategoryRewardsMenu;
import gg.auroramc.collections.menu.CollectionsMenu;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class CategoryMenu {
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"collections_category_menu");
    private final Player player;
    private final AuroraCollections plugin;

    public CategoryMenu(Player player, AuroraCollections plugin) {
        this.player = player;
        this.plugin = plugin;
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        CategoriesMenuConfig config = this.plugin.getConfigManager().getCategoriesMenuConfig();
        AuroraMenu menu = new AuroraMenu(this.player, config.getTitle(), config.getRows() * 9, false, menuId, new Placeholder[0]);
        if (config.getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)config.getFiller().getItem()).toItemStack(this.player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        List<Placeholder<?>> globalPlaceholders = this.plugin.getCollectionManager().getGlobalPlaceholders(this.player);
        for (ItemConfig itemConfig : config.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)itemConfig).placeholder(globalPlaceholders).build(this.player));
        }
        for (Map.Entry entry : config.getItems().entrySet()) {
            String category = (String)entry.getKey();
            List<Placeholder<?>> placeholders = this.plugin.getCollectionManager().getCategoryPlaceholders(category, this.player);
            placeholders.addAll(globalPlaceholders);
            MenuItem builtItem = ItemBuilder.of((ItemConfig)((ItemConfig)entry.getValue())).placeholder(placeholders).build(this.player);
            if (!this.plugin.getCollectionManager().getCategory(category).hasPermission(this.player)) {
                menu.addItem(builtItem);
                continue;
            }
            menu.addItem(builtItem, e -> {
                if (e.isRightClick() && this.plugin.getCollectionManager().getCategory(category).isLevelingEnabled()) {
                    new CategoryRewardsMenu(this.player, this.plugin, category).open();
                } else {
                    new CollectionsMenu(this.player, this.plugin, category).open();
                }
            });
        }
        return menu;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

