/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.menu;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Category;
import gg.auroramc.collections.collection.CategoryReward;
import gg.auroramc.collections.config.CategoriesConfig;
import gg.auroramc.collections.config.menu.CategoryRewardsMenuConfig;
import gg.auroramc.collections.menu.CategoryMenu;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class CategoryRewardsMenu {
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"collections_category_rewards_menu");
    private final Player player;
    private final AuroraCollections plugin;
    private final String category;

    public CategoryRewardsMenu(Player player, AuroraCollections plugin, String category) {
        this.player = player;
        this.plugin = plugin;
        this.category = category;
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        CategoryRewardsMenuConfig config = this.plugin.getConfigManager().getCategoryRewardsMenuConfig();
        CategoriesConfig.CategoryConfig cf = this.plugin.getConfigManager().getCategoriesConfig().getCategories().get(this.category);
        AuroraMenu menu = new AuroraMenu(this.player, config.getTitle(), config.getRows() * 9, false, menuId, new Placeholder[]{Placeholder.of((String)"{category_name}", (String)cf.getName())});
        if (config.getItems().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)config.getItems().getFiller().getItem()).toItemStack(this.player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        for (ItemConfig customItem : config.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).build(this.player));
        }
        CategoryRewardsMenuConfig.Items items = config.getItems();
        menu.addItem(ItemBuilder.back((ItemConfig)items.getBack()).build(this.player), e -> new CategoryMenu(this.player, this.plugin).open());
        Category category = this.plugin.getCollectionManager().getCategory(this.category);
        List<CategoryReward> rewards = category.getRewards();
        if (!category.isLevelingEnabled()) {
            return menu;
        }
        double currentPercentage = this.plugin.getCollectionManager().getCategoryCompletionPercent(this.category, this.player) * 100.0;
        boolean previousCompleted = true;
        for (int i = 0; i < config.getDisplayArea().size(); ++i) {
            Integer slot = config.getDisplayArea().get(i);
            if (rewards.size() == i) break;
            CategoryReward reward = rewards.get(i);
            boolean completed = currentPercentage >= reward.percentage();
            boolean inProgress = !completed && previousCompleted;
            previousCompleted = completed;
            ItemConfig itemConfig = inProgress ? config.getItems().getNextLevel() : (completed ? config.getItems().getCompletedLevel() : config.getItems().getLockedLevel());
            itemConfig = itemConfig.merge(reward.items().get(inProgress ? "next-level" : (completed ? "completed-level" : "locked-level")));
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{player}", (String)this.player.getName()), Placeholder.of((String)"{category_name}", (String)cf.getName()), Placeholder.of((String)"{category_id}", (String)this.category), Placeholder.of((String)"{percent}", (String)AuroraAPI.formatNumber((double)reward.percentage())), Placeholder.of((String)"{progress_percent}", (String)AuroraAPI.formatNumber((double)currentPercentage)));
            ArrayList<String> lore = new ArrayList<String>();
            List<Reward> levelRewards = reward.rewards();
            for (String line : itemConfig.getLore()) {
                if (line.equals("component:rewards")) {
                    CategoryRewardsMenuConfig.DisplayComponent display = config.getDisplayComponents().get("rewards");
                    if (!levelRewards.isEmpty()) {
                        lore.add(display.getTitle());
                    }
                    for (Reward r : levelRewards) {
                        lore.add(display.getLine().replace("{reward}", r.getDisplay(this.player, placeholders)));
                    }
                    continue;
                }
                lore.add(line);
            }
            ItemBuilder builder = ItemBuilder.of((ItemConfig)itemConfig).slot(slot.intValue()).loreCompute(() -> lore.stream().map(l -> Text.component((Player)this.player, (String)l, (List)placeholders)).toList()).placeholder(placeholders);
            menu.addItem(builder.build(this.player));
        }
        return menu;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

