/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.menu;

import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.config.CategoriesConfig;
import gg.auroramc.collections.config.menu.CollectionListMenuConfig;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import gg.auroramc.collections.menu.CategoryMenu;
import gg.auroramc.collections.menu.ProgressionMenu;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CollectionsMenu {
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"collections_menu");
    private final Player player;
    private final AuroraCollections plugin;
    private final String category;
    private int page = 0;

    public CollectionsMenu(Player player, AuroraCollections plugin, String category) {
        this.player = player;
        this.plugin = plugin;
        this.category = category;
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        CollectionListMenuConfig config = this.plugin.getConfigManager().getCollectionListMenuConfig();
        CollectionMenuConfig cConfig = this.plugin.getConfigManager().getCollectionMenuConfig();
        Map<String, CategoriesConfig.CategoryConfig> categories = this.plugin.getConfigManager().getCategoriesConfig().getCategories();
        AuroraMenu menu = new AuroraMenu(this.player, config.getTitle(), config.getRows() * 9, false, menuId, new Placeholder[]{Placeholder.of((String)"{category}", (String)categories.get(this.category).getName())});
        if (config.getItems().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)config.getItems().getFiller().getItem()).toItemStack(this.player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        for (ItemConfig customItem : config.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).build(this.player));
        }
        CollectionListMenuConfig.Items items = config.getItems();
        menu.addItem(ItemBuilder.back((ItemConfig)items.getBack()).build(this.player), e -> new CategoryMenu(this.player, this.plugin).open());
        if (this.plugin.getConfigManager().getCollectionListMenuConfig().getCategoryIcon().getEnabled().booleanValue()) {
            ItemConfig itemConfig = this.plugin.getConfigManager().getCategoriesMenuConfig().getItems().get(this.category).merge(this.plugin.getConfigManager().getCollectionListMenuConfig().getCategoryIcon().getItem());
            List<Placeholder<?>> placeholders = this.plugin.getCollectionManager().getCategoryPlaceholders(this.category, this.player);
            menu.addItem(ItemBuilder.of((ItemConfig)itemConfig).placeholder(placeholders).build(this.player));
        }
        List<Collection> collections = this.getPage(this.page, config.getDisplayArea().size());
        for (int i = 0; i < config.getDisplayArea().size(); ++i) {
            Integer slot = config.getDisplayArea().get(i);
            if (collections.size() <= i) {
                menu.addItem(ItemBuilder.item((ItemStack)new ItemStack(Material.AIR)).slot(slot.intValue()).build(this.player));
                continue;
            }
            Collection collection = collections.get(i);
            CollectionMenuConfig.ItemTemplate template = cConfig.getCollectionMenuTemplate();
            ItemConfig itemConfig = template.getEnabled() != false ? template.getItem().merge(collection.getConfig().getMenuItem()) : collection.getConfig().getMenuItem();
            boolean hidden = false;
            if (config.getSecretCollectionDisplay().getEnabled().booleanValue() && collection.getCount(this.player) == 0L) {
                itemConfig = config.getSecretCollectionDisplay().getItem();
                hidden = true;
            }
            ItemBuilder builder = ItemBuilder.of((ItemConfig)itemConfig).slot(slot.intValue()).placeholder(collection.getPlaceholders(this.player, collection.getPlayerLevel(this.player) + 1));
            if (hidden) {
                menu.addItem(builder.build(this.player));
                continue;
            }
            menu.addItem(builder.build(this.player), e -> {
                if (!collection.hasPermission(this.player)) {
                    return;
                }
                new ProgressionMenu(this.player, this.plugin, collection).open();
            });
        }
        int pageCount = this.getTotalPageCount(config.getDisplayArea().size());
        if (this.plugin.getCollectionManager().getCollectionsByCategory(this.category).size() > config.getDisplayArea().size()) {
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(pageCount + 1)));
            menu.addItem(ItemBuilder.of((ItemConfig)items.getPreviousPage()).defaultSlot(48).placeholder(placeholders).build(this.player), e -> {
                if (this.page > 0) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)items.getCurrentPage()).defaultSlot(49).placeholder(placeholders).build(this.player));
            menu.addItem(ItemBuilder.of((ItemConfig)items.getNextPage()).defaultSlot(50).placeholder(placeholders).build(this.player), e -> {
                if (this.page < pageCount) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        return menu;
    }

    private List<Collection> getPage(int page, int pageSize) {
        List<Collection> collections = this.plugin.getCollectionManager().getCollectionsByCategory(this.category);
        return collections.stream().skip((long)page * (long)pageSize).limit(pageSize).toList();
    }

    private int getTotalPageCount(int pageSize) {
        List<Collection> collections = this.plugin.getCollectionManager().getCollectionsByCategory(this.category);
        return (int)Math.ceil((double)collections.size() / (double)pageSize) - 1;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

