/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.menu;

import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.levels.ConcreteMatcher;
import gg.auroramc.aurora.api.levels.IntervalMatcher;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import gg.auroramc.collections.menu.CollectionsMenu;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ProgressionMenu {
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"collections_progression_menu");
    private final Player player;
    private final AuroraCollections plugin;
    private final Collection collection;
    private int page = 0;

    public ProgressionMenu(Player player, AuroraCollections plugin, Collection collection) {
        this.player = player;
        this.plugin = plugin;
        this.collection = collection;
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        CollectionMenuConfig config = this.plugin.getConfigManager().getCollectionMenuConfig();
        AuroraMenu menu = new AuroraMenu(this.player, config.getTitle(), config.getRows() * 9, false, menuId, new Placeholder[]{Placeholder.of((String)"{collection_name}", (String)this.collection.getConfig().getName()), Placeholder.of((String)"{collection_title}", (String)this.collection.getMenuTitle())});
        if (config.getItems().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)config.getItems().getFiller().getItem()).toItemStack(this.player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        List<Placeholder<?>> currentPlaceholders = this.collection.getPlaceholders(this.player, this.collection.getPlayerLevel(this.player));
        for (ItemConfig customItem : config.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).placeholder(currentPlaceholders).build(this.player));
        }
        for (ItemConfig customItem : this.collection.getConfig().getCustomMenuItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).placeholder(currentPlaceholders).build(this.player));
        }
        CollectionMenuConfig.Items items = config.getItems();
        menu.addItem(ItemBuilder.back((ItemConfig)items.getBack()).build(this.player), e -> new CollectionsMenu(this.player, this.plugin, this.collection.getCategory()).open());
        CollectionMenuConfig.ItemTemplate template = config.getCollectionMenuTemplate();
        ItemConfig iconConfig = template.getEnabled() != false ? template.getItem().merge(this.collection.getConfig().getMenuItem()) : this.collection.getConfig().getMenuItem();
        ItemBuilder iconBuilder = ItemBuilder.of((ItemConfig)iconConfig).placeholder(this.collection.getPlaceholders(this.player, this.collection.getPlayerLevel(this.player) + 1)).defaultSlot(4);
        menu.addItem(iconBuilder.build(this.player));
        List<Integer> requirements = this.getPage(this.page, config.getDisplayArea().size());
        for (int i = 0; i < config.getDisplayArea().size(); ++i) {
            String mergeKey;
            ItemConfig itemConfig;
            Integer slot = config.getDisplayArea().get(i);
            if (requirements.size() <= i) break;
            Integer requirement = requirements.get(i);
            int level = this.collection.getConfig().getRequirements().indexOf(requirement) + 1;
            int playerLevel = this.collection.getPlayerLevel(this.player);
            boolean completed = playerLevel >= level;
            boolean inProgress = playerLevel + 1 == level;
            LevelMatcher matcher = this.collection.getLevelMatcher().getBestMatcher(level);
            ItemConfig itemConfig2 = inProgress ? config.getItems().getNextLevel() : (itemConfig = completed ? config.getItems().getCompletedLevel() : config.getItems().getLockedLevel());
            String string = inProgress ? "next-level" : (mergeKey = completed ? "completed-level" : "locked-level");
            if (matcher instanceof IntervalMatcher) {
                IntervalMatcher intervalMatcher = (IntervalMatcher)matcher;
                if (intervalMatcher.getConfig().getItem().containsKey("generic-level")) {
                    itemConfig = itemConfig.merge((ItemConfig)intervalMatcher.getConfig().getItem().get("generic-level"));
                }
                itemConfig = itemConfig.merge((ItemConfig)intervalMatcher.getConfig().getItem().get(mergeKey));
            } else if (matcher instanceof ConcreteMatcher) {
                ConcreteMatcher concreteMatcher = (ConcreteMatcher)matcher;
                if (concreteMatcher.getConfig().getItem().containsKey("generic-level")) {
                    itemConfig = itemConfig.merge((ItemConfig)concreteMatcher.getConfig().getItem().get("generic-level"));
                }
                itemConfig = itemConfig.merge((ItemConfig)concreteMatcher.getConfig().getItem().get(mergeKey));
            }
            List<Placeholder<?>> placeholders = this.collection.getPlaceholders(this.player, level);
            ArrayList<String> lore = new ArrayList<String>();
            List rewards = matcher.computeRewards(level);
            for (String line : itemConfig.getLore()) {
                if (line.equals("component:rewards")) {
                    CollectionMenuConfig.DisplayComponent display = config.getDisplayComponents().get("rewards");
                    if (!rewards.isEmpty()) {
                        lore.add(display.getTitle());
                    }
                    for (Reward reward : rewards) {
                        lore.add(display.getLine().replace("{reward}", reward.getDisplay(this.player, placeholders)));
                    }
                    continue;
                }
                lore.add(line);
            }
            ItemBuilder builder = ItemBuilder.of((ItemConfig)itemConfig).slot(slot.intValue()).loreCompute(() -> lore.stream().map(l -> Text.component((Player)this.player, (String)l, (List)placeholders)).toList()).placeholder(placeholders);
            if (config.getAllowItemAmounts().booleanValue()) {
                builder.amount(level);
            }
            menu.addItem(builder.build(this.player));
        }
        int pageCount = this.getTotalPageCount(config.getDisplayArea().size());
        if (this.collection.getConfig().getRequirements().size() > config.getDisplayArea().size()) {
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(pageCount + 1)));
            menu.addItem(ItemBuilder.of((ItemConfig)items.getPreviousPage()).defaultSlot(48).placeholder(placeholders).build(this.player), e -> {
                if (this.page > 0) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)items.getCurrentPage()).defaultSlot(49).placeholder(placeholders).build(this.player));
            menu.addItem(ItemBuilder.of((ItemConfig)items.getNextPage()).defaultSlot(50).placeholder(placeholders).build(this.player), e -> {
                if (this.page < pageCount) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        return menu;
    }

    private List<Integer> getPage(int page, int pageSize) {
        List<Integer> requirements = this.collection.getConfig().getRequirements();
        return requirements.stream().skip((long)page * (long)pageSize).limit(pageSize).toList();
    }

    private int getTotalPageCount(int pageSize) {
        List<Integer> requirements = this.collection.getConfig().getRequirements();
        return (int)Math.ceil((double)requirements.size() / (double)pageSize) - 1;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

